/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class Selection
extends SpelNodeImpl {
    public static final int ALL = 0;
    public static final int FIRST = 1;
    public static final int LAST = 2;
    private final int variant;
    private final boolean nullSafe;

    public Selection(boolean nullSafe, int variant, int pos, SpelNodeImpl expression) {
        SpelNodeImpl[] spelNodeImplArray;
        if (expression != null) {
            SpelNodeImpl[] spelNodeImplArray2 = new SpelNodeImpl[1];
            spelNodeImplArray = spelNodeImplArray2;
            spelNodeImplArray2[0] = expression;
        } else {
            spelNodeImplArray = new SpelNodeImpl[]{};
        }
        super(pos, spelNodeImplArray);
        Assert.notNull((Object)expression, (String)"Expression must not be null");
        this.nullSafe = nullSafe;
        this.variant = variant;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        return this.getValueRef(state).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        TypedValue op = state.getActiveContextObject();
        Object operand = op.getValue();
        SpelNodeImpl selectionCriteria = this.children[0];
        if (operand instanceof Map) {
            Map mapdata = (Map)operand;
            HashMap result = new HashMap();
            Object lastKey = null;
            for (Map.Entry entry : mapdata.entrySet()) {
                try {
                    TypedValue typedValue = new TypedValue(entry);
                    state.pushActiveContextObject(typedValue);
                    Object o = selectionCriteria.getValueInternal(state).getValue();
                    if (o instanceof Boolean) {
                        if (!((Boolean)o).booleanValue()) continue;
                        if (this.variant == 1) {
                            result.put(entry.getKey(), entry.getValue());
                            ValueRef.TypedValueHolderValueRef typedValueHolderValueRef = new ValueRef.TypedValueHolderValueRef(new TypedValue(result), this);
                            return typedValueHolderValueRef;
                        }
                        result.put(entry.getKey(), entry.getValue());
                        lastKey = entry.getKey();
                        continue;
                    }
                    throw new SpelEvaluationException(selectionCriteria.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                }
                finally {
                    state.popActiveContextObject();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && result.size() == 0) {
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(null), this);
            }
            if (this.variant == 2) {
                HashMap resultMap = new HashMap();
                Object lastValue = result.get(lastKey);
                resultMap.put(lastKey, lastValue);
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(resultMap), this);
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(result), this);
        }
        if (operand instanceof Collection || ObjectUtils.isArray((Object)operand)) {
            ArrayList<Object> data = new ArrayList<Object>();
            List<Object> c = operand instanceof Collection ? (List<Object>)operand : Arrays.asList(ObjectUtils.toObjectArray((Object)operand));
            data.addAll(c);
            ArrayList result = new ArrayList();
            int idx = 0;
            for (Object e : data) {
                try {
                    state.pushActiveContextObject(new TypedValue(e));
                    state.enterScope("index", idx);
                    Object o = selectionCriteria.getValueInternal(state).getValue();
                    if (o instanceof Boolean) {
                        if (((Boolean)o).booleanValue()) {
                            if (this.variant == 1) {
                                ValueRef.TypedValueHolderValueRef typedValueHolderValueRef = new ValueRef.TypedValueHolderValueRef(new TypedValue(e), this);
                                return typedValueHolderValueRef;
                            }
                            result.add(e);
                        }
                    } else {
                        throw new SpelEvaluationException(selectionCriteria.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                    }
                    ++idx;
                }
                finally {
                    state.exitScope();
                    state.popActiveContextObject();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && result.size() == 0) {
                return ValueRef.NullValueRef.instance;
            }
            if (this.variant == 2) {
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(result.get(result.size() - 1)), this);
            }
            if (operand instanceof Collection) {
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(result), this);
            }
            Class elementType = ClassUtils.resolvePrimitiveIfNecessary((Class)op.getTypeDescriptor().getElementTypeDescriptor().getType());
            Object object = Array.newInstance(elementType, result.size());
            System.arraycopy(result.toArray(), 0, object, 0, result.size());
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(object), this);
        }
        if (operand == null) {
            if (this.nullSafe) {
                return ValueRef.NullValueRef.instance;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, operand.getClass().getName());
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder();
        switch (this.variant) {
            case 0: {
                sb.append("?[");
                break;
            }
            case 1: {
                sb.append("^[");
                break;
            }
            case 2: {
                sb.append("$[");
            }
        }
        return sb.append(this.getChild(0).toStringAST()).append("]").toString();
    }
}

