/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim;

import com.sun.javafx.scene.web.Debugger;
import java.text.MessageFormat;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.vpe.browsersim.browser.ExtendedOpenWindowListener;
import org.jboss.tools.vpe.browsersim.browser.ExtendedWindowEvent;
import org.jboss.tools.vpe.browsersim.browser.IBrowser;
import org.jboss.tools.vpe.browsersim.browser.PlatformUtil;
import org.jboss.tools.vpe.browsersim.browser.WebKitBrowserFactory;
import org.jboss.tools.vpe.browsersim.browser.javafx.JavaFXBrowser;
import org.jboss.tools.vpe.browsersim.devtools.DevToolsDebuggerServer;
import org.jboss.tools.vpe.browsersim.model.preferences.SpecificPreferences;
import org.jboss.tools.vpe.browsersim.ui.CocoaUIEnhancer;
import org.jboss.tools.vpe.browsersim.ui.ExceptionNotifier;
import org.jboss.tools.vpe.browsersim.ui.events.ExitListener;
import org.jboss.tools.vpe.browsersim.ui.events.SkinChangeEvent;
import org.jboss.tools.vpe.browsersim.ui.events.SkinChangeListener;
import org.jboss.tools.vpe.browsersim.util.BrowserSimUtil;
import org.jboss.tools.vpe.browsersim.util.PreferencesUtil;
import org.jboss.tools.vpe.cordovasim.CordovaSimArgs;
import org.jboss.tools.vpe.cordovasim.CordovaSimLogger;
import org.jboss.tools.vpe.cordovasim.CustomBrowserSim;
import org.jboss.tools.vpe.cordovasim.Messages;
import org.jboss.tools.vpe.cordovasim.events.RippleInjector;
import org.jboss.tools.vpe.cordovasim.model.preferences.CordavaSimSpecificPreferencesStorage;
import org.jboss.tools.vpe.cordovasim.model.preferences.CordovaSimSpecificPreferences;
import org.jboss.tools.vpe.cordovasim.plugin.inappbrowser.InAppBrowserLoader;
import org.jboss.tools.vpe.cordovasim.util.CordovaSimImageList;
import org.jboss.tools.vpe.cordovasim.util.CordovaSimUtil;
import org.jboss.tools.vpe.cordovasim.util.StartPageParametersUtil;

public class CordovaSimRunner {
    public static final String PLUGIN_ID = "org.jboss.tools.vpe.cordovasim";
    private static final String STOP_SERVER_COMMAND = "org.jboss.tools.vpe.cordavasim.command.stop.server:";
    private static CustomBrowserSim browserSim;
    private static final String[] CORDOVASIM_ICONS;
    private static boolean isJavaFxAvailable;
    private static boolean isWebKitAvailable;

    static {
        CORDOVASIM_ICONS = new String[]{"icons/cordovasim_36px.png", "icons/cordovasim_48px.png", "icons/cordovasim_72px.png", "icons/cordovasim_96px.png"};
        if ("macosx".equals(PlatformUtil.getOs())) {
            CocoaUIEnhancer.initializeMacOSMenuBar((String)Messages.CordovaSim_CORDOVA_SIM);
        }
        String platform = PlatformUtil.getOs();
        isJavaFxAvailable = false;
        boolean isLinux = "linux".equals(platform);
        if (!isLinux || BrowserSimUtil.isRunningAgainstGTK2()) {
            isJavaFxAvailable = BrowserSimUtil.loadJavaFX();
        }
        isWebKitAvailable = BrowserSimUtil.isWebkitAvailable();
    }

    public static void main(String[] args) throws Exception {
        CordovaSimArgs.parseArgs(args);
        CordovaSimRunner.startCordovaSim();
    }

    private static void startCordovaSim() throws Exception {
        Display display = Display.getDefault();
        try {
            try {
                if (!isJavaFxAvailable && !isWebKitAvailable) {
                    String errorMessage = "";
                    String os = PlatformUtil.getOs();
                    if ("linux".equals(os)) {
                        errorMessage = MessageFormat.format(org.jboss.tools.vpe.browsersim.ui.Messages.BrowserSim_NO_WEB_ENGINES_LINUX, Messages.CordovaSim_CORDOVA_SIM);
                    } else if ("win32".equals(os)) {
                        errorMessage = MessageFormat.format(org.jboss.tools.vpe.browsersim.ui.Messages.BrowserSim_NO_WEB_ENGINES_WINDOWS, Messages.CordovaSim_CORDOVA_SIM);
                    }
                    throw new SWTError(errorMessage);
                }
                Shell shell = CordovaSimRunner.createCordovaSim(display);
                while (!shell.isDisposed()) {
                    if (shell.getDisplay().readAndDispatch()) continue;
                    shell.getDisplay().sleep();
                }
            }
            catch (SWTError e) {
                ExceptionNotifier.showBrowserSimLoadError((Shell)new Shell(Display.getDefault()), (SWTError)e, (String)Messages.CordovaSim_CORDOVA_SIM);
                if (!CordovaSimArgs.isRestartRequired()) {
                    CordovaSimRunner.sendStopServerCommand();
                } else if (display != null) {
                    display.dispose();
                }
            }
            catch (Throwable t) {
                CordovaSimLogger.logError(t.getMessage(), t);
                if (!CordovaSimArgs.isRestartRequired()) {
                    CordovaSimRunner.sendStopServerCommand();
                } else if (display != null) {
                    display.dispose();
                }
            }
        }
        finally {
            if (!CordovaSimArgs.isRestartRequired()) {
                CordovaSimRunner.sendStopServerCommand();
            } else if (display != null) {
                display.dispose();
            }
        }
    }

    private static void createBrowserSim(SpecificPreferences sp, final IBrowser rippleToolBarBrowser, String homeUrl) {
        Shell parentShell = rippleToolBarBrowser.getShell();
        if (parentShell != null) {
            browserSim = new CustomBrowserSim(homeUrl, parentShell);
            browserSim.setRippleToolBarBrowser(rippleToolBarBrowser);
            browserSim.open(sp, null);
            browserSim.addSkinChangeListener(new SkinChangeListener(){

                public void skinChanged(SkinChangeEvent event) {
                    rippleToolBarBrowser.refresh();
                }
            });
            browserSim.addExitListener(new ExitListener(){

                public void exit() {
                    rippleToolBarBrowser.getShell().dispose();
                }
            });
            IBrowser browser = browserSim.getBrowser();
            browser.addLocationListener((LocationListener)new RippleInjector(browserSim));
            CordovaSimUtil.fixScrollbarStylesForMac(browser);
        }
    }

    private static Image[] initImages(Shell shell) {
        CordovaSimImageList imageList = new CordovaSimImageList((Widget)shell);
        Image[] icons = new Image[CORDOVASIM_ICONS.length];
        int i = 0;
        while (i < CORDOVASIM_ICONS.length) {
            icons[i] = imageList.getImage(CORDOVASIM_ICONS[i]);
            ++i;
        }
        return icons;
    }

    private static CordovaSimSpecificPreferences loadPreferences() {
        CordovaSimSpecificPreferences sp = (CordovaSimSpecificPreferences)((Object)CordavaSimSpecificPreferencesStorage.INSTANCE.load(PreferencesUtil.getConfigFolderPath()));
        if (sp == null) {
            sp = (CordovaSimSpecificPreferences)CordavaSimSpecificPreferencesStorage.INSTANCE.loadDefault();
        }
        return sp;
    }

    private static void setShellAttributes(Shell shell) {
        Image[] icons = CordovaSimRunner.initImages(shell);
        shell.setImages(icons);
        shell.setText(Messages.CordovaSim_CORDOVA_SIM);
    }

    private static Shell createCordovaSim(Display display) throws Exception {
        final CordovaSimSpecificPreferences sp = CordovaSimRunner.loadPreferences();
        if (!isWebKitAvailable && isJavaFxAvailable) {
            sp.setJavaFx(true);
        }
        if (!isJavaFxAvailable) {
            sp.setJavaFx(false);
        }
        final Shell shell = new Shell(display);
        CordovaSimRunner.setShellAttributes(shell);
        shell.setLayout((Layout)new FillLayout());
        final IBrowser rippleToolBarBrowser = new WebKitBrowserFactory().createBrowser((Composite)shell, 65536, sp.isJavaFx());
        final String homeUrl = CordovaSimArgs.getHomeUrl();
        String startPageParameters = StartPageParametersUtil.getStartPageParameters(homeUrl);
        if (startPageParameters != null) {
            CordovaSimRunner.processStartPageParameters(rippleToolBarBrowser, startPageParameters);
        }
        rippleToolBarBrowser.setUrl(StartPageParametersUtil.getRippleHomeUrl(homeUrl));
        shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                browserSim.getBrowser().getShell().close();
            }
        });
        if (sp.getCordovaBrowserSize() != null) {
            shell.setSize(sp.getCordovaBrowserSize());
        } else {
            sp.setCordovaBrowserSize(shell.getSize());
        }
        Point location = sp.getCordovaBrowserLocation();
        if (location != null) {
            BrowserSimUtil.setShellLocation((Shell)shell, (Point)shell.getSize(), (Point)location);
        } else {
            sp.setCordovaBrowserLocation(shell.getLocation());
        }
        rippleToolBarBrowser.addOpenWindowListener(new ExtendedOpenWindowListener(){
            private IBrowser oldBrowser;

            public void open(ExtendedWindowEvent event) {
                if (InAppBrowserLoader.isInAppBrowserEvent(event) && browserSim != null) {
                    InAppBrowserLoader.processInAppBrowser(rippleToolBarBrowser, browserSim, event);
                } else {
                    if (browserSim == null || browserSim.getBrowser().isDisposed() || browserSim.getBrowser().getShell().isDisposed()) {
                        CordovaSimRunner.createBrowserSim(sp, rippleToolBarBrowser, homeUrl);
                    } else if (this.oldBrowser == browserSim.getBrowser()) {
                        browserSim.reinitSkin();
                        browserSim.getBrowser().addLocationListener((LocationListener)new RippleInjector(browserSim));
                    } else if (this.oldBrowser != browserSim.getBrowser()) {
                        browserSim.getBrowser().addLocationListener((LocationListener)new RippleInjector(browserSim));
                    }
                    event.browser = browserSim.getBrowser();
                    this.oldBrowser = browserSim.getBrowser();
                    try {
                        if (browserSim.getBrowser() instanceof JavaFXBrowser && !"STARTED".equals(DevToolsDebuggerServer.getServerState())) {
                            DevToolsDebuggerServer.startDebugServer((Debugger)((JavaFXBrowser)browserSim.getBrowser()).getDebugger());
                        }
                    }
                    catch (Exception e) {
                        CordovaSimLogger.logError(e.getMessage(), e);
                    }
                }
            }
        });
        shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                if (browserSim != null) {
                    browserSim.getSpecificPreferences().setCordovaBrowserLocation(shell.getLocation());
                }
                super.controlMoved(e);
            }
        });
        shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (browserSim != null) {
                    browserSim.getSpecificPreferences().setCordovaBrowserSize(shell.getSize());
                }
            }
        });
        shell.open();
        return shell;
    }

    private static void processStartPageParameters(final IBrowser rippleToolBarBrowser, String startPageParameters) {
        final String addingStartPageParametersFunction = "window._startPageParameters = '" + startPageParameters + "';";
        rippleToolBarBrowser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent event) {
                rippleToolBarBrowser.execute(addingStartPageParametersFunction);
            }
        });
    }

    private static void sendStopServerCommand() {
        System.out.println("org.jboss.tools.vpe.cordavasim.command.stop.server: Server on port " + CordovaSimArgs.getPort() + " was stopped");
    }
}

