/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.jdt.core;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.springframework.ide.eclipse.data.jdt.core.ChangeParameterTypeResolution;

public class InvalidParameterTypeMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        int endPos;
        int startPos;
        AssistContext assistContext;
        ASTNode astNode;
        MethodDeclaration methodDecl;
        if (!this.hasResolutions(marker)) {
            return new IMarkerResolution[0];
        }
        IResource resource = marker.getResource();
        ICompilationUnit cu = null;
        if (resource instanceof IFile && resource.isAccessible()) {
            IJavaElement element = JavaCore.create((IFile)((IFile)resource));
            if (!(element instanceof ICompilationUnit)) {
                return new IMarkerResolution[0];
            }
            cu = (ICompilationUnit)element;
        }
        if ((methodDecl = this.getSurroundingMethod(astNode = (assistContext = new AssistContext(cu, startPos = marker.getAttribute("charStart", 0), (endPos = marker.getAttribute("charEnd", 0)) - startPos)).getCoveringNode())) == null) {
            return new IMarkerResolution[0];
        }
        List parameters = methodDecl.parameters();
        if (parameters.size() != 1) {
            return new IMarkerResolution[0];
        }
        String propertyTypeName = marker.getAttribute("PROPERTY_TYPE_ATTR", null);
        String propertyTypePackage = marker.getAttribute("PROPERTY_TYPE_PACKAGE_ATTR", null);
        return new IMarkerResolution[]{new ChangeParameterTypeResolution((SingleVariableDeclaration)parameters.get(0), propertyTypeName, propertyTypePackage, cu)};
    }

    private MethodDeclaration getSurroundingMethod(ASTNode astNode) {
        if (astNode instanceof MethodDeclaration || astNode == null) {
            return (MethodDeclaration)astNode;
        }
        return this.getSurroundingMethod(astNode.getParent());
    }

    public boolean hasResolutions(IMarker marker) {
        String problemId = marker.getAttribute("org.eclipse.core.resources.problemmarker", null);
        String propertyTypeName = marker.getAttribute("PROPERTY_TYPE_ATTR", null);
        String propertyTypePackage = marker.getAttribute("PROPERTY_TYPE_PACKAGE_ATTR", null);
        return "INVALID_PARAMETER_TYPE".equals(problemId) && propertyTypeName != null && propertyTypePackage != null;
    }
}

