/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.jdt.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.ui.SharedImages;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComputer;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.data.internal.DataCoreImages;
import org.springframework.ide.eclipse.data.jdt.core.KeywordProvider;
import org.springframework.ide.eclipse.data.jdt.core.QueryMethodCandidate;
import org.springframework.ide.eclipse.data.jdt.core.QueryMethodPart;
import org.springframework.ide.eclipse.data.jdt.core.RepositoryInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityPropertyCompletionProposals
extends JavaCompletionProposalComputer {
    private static final ISharedImages IMAGES = new SharedImages();
    private static final Image KEYWORD = DataCoreImages.getImage("org.springframework.ide.eclipse.data.core.key_obj.gif");

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return Collections.emptyList();
        }
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        if (!SpringCoreUtils.isSpringProject((IResource)javaContext.getProject().getProject())) {
            return Collections.emptyList();
        }
        if (javaContext.getCoreContext() == null) {
            return Collections.emptyList();
        }
        ICompilationUnit cu = javaContext.getCompilationUnit();
        try {
            IType type;
            int invocationOffset = context.getInvocationOffset();
            IJavaElement element = cu.getElementAt(invocationOffset);
            if (element instanceof SourceMethod) {
                return this.computeCompletionProposals((SourceMethod)element, javaContext);
            }
            if (element != null && (type = (IType)element.getAncestor(7)) != null) {
                return this.computeCompletionProposals(type, javaContext);
            }
        }
        catch (JavaModelException javaModelException) {}
        return Collections.emptyList();
    }

    private List<ICompletionProposal> computeCompletionProposals(SourceMethod element, JavaContentAssistInvocationContext javaContext) throws JavaModelException {
        RepositoryInformation information = RepositoryInformation.create((IMethod)element);
        if (information == null) {
            return Collections.emptyList();
        }
        int offset = javaContext.getCoreContext().getOffset();
        int positionInMethodName = offset - element.getNameRange().getOffset();
        String elementName = element.getElementName();
        return this.computeCompletionProposals(javaContext, information, positionInMethodName, elementName);
    }

    private List<ICompletionProposal> computeCompletionProposals(IType type, JavaContentAssistInvocationContext javaContext) throws JavaModelException {
        RepositoryInformation information = RepositoryInformation.create(type);
        if (information == null) {
            return Collections.emptyList();
        }
        char[] token = javaContext.getCoreContext().getToken();
        if (token == null) {
            return Collections.emptyList();
        }
        String elementName = String.valueOf(token);
        if (elementName.isEmpty()) {
            return Collections.emptyList();
        }
        int offset = javaContext.getCoreContext().getOffset();
        int positionInMethodName = offset - javaContext.getCoreContext().getTokenStart();
        return this.computeCompletionProposals(javaContext, information, positionInMethodName, elementName);
    }

    private List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext javaContext, RepositoryInformation information, int positionInMethodName, String elementName) throws JavaModelException {
        IType type;
        IJavaProject project = javaContext.getProject();
        Class<?> managedDomainClass = information.getManagedDomainClass();
        if (managedDomainClass == null) {
            return Collections.emptyList();
        }
        IType domainType = project.findType(managedDomainClass.getName());
        int offset = javaContext.getCoreContext().getOffset();
        KeywordProvider keywordProvider = information.getKeywordProvider(project);
        QueryMethodCandidate candidate = new QueryMethodCandidate(elementName, information.getManagedDomainClass());
        QueryMethodPart part = candidate.getPartAtPosition(positionInMethodName);
        if (part == null) {
            return Collections.emptyList();
        }
        KeywordProposalsProvider keywordProposalsProvider = new KeywordProposalsProvider(keywordProvider);
        IType iType = type = part.isRoot() ? domainType : project.findType(part.getPathLeaf().getType().getName());
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        proposals.addAll(EntityPropertyCompletionProposals.getProposalsFor(type, part, offset));
        proposals.addAll(keywordProposalsProvider.getProposalsFor(type, offset, part));
        return proposals;
    }

    private static List<ICompletionProposal> getProposalsFor(IType type, QueryMethodPart part, int offset) throws JavaModelException {
        if (EntityPropertyCompletionProposals.isJdkType(type)) {
            return Collections.emptyList();
        }
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (part.isProposalCandidate(field)) {
                result.add((ICompletionProposal)new EntityFieldNameCompletionProposal(field, offset, part.getSeed()));
            }
            ++n2;
        }
        return result;
    }

    private static boolean isJdkType(IType type) {
        return type.getFullyQualifiedName().startsWith("java");
    }

    private static String getReplacement(String source, String seed) {
        return StringUtils.hasText((String)seed) ? source.substring(seed.length()) : StringUtils.capitalize((String)source);
    }

    static /* synthetic */ ISharedImages access$2() {
        return IMAGES;
    }

    private static class EntityFieldNameCompletionProposal
    extends JavaCompletionProposal {
        private static final Image DEFAULT_FIELD = EntityPropertyCompletionProposals.access$2().getImage("org.eclipse.jdt.ui.field_default_obj.gif");
        private static final Image PRIVATE_FIELD = EntityPropertyCompletionProposals.access$2().getImage("org.eclipse.jdt.ui.field_private_obj.gif");
        private static final Image PROTECTED_FIELD = EntityPropertyCompletionProposals.access$2().getImage("org.eclipse.jdt.ui.field_protected_obj.gif");
        private static final Image PUBLIC_FIELD = EntityPropertyCompletionProposals.access$2().getImage("org.eclipse.jdt.ui.field_public_obj.gif");
        private String fieldName;

        public EntityFieldNameCompletionProposal(IField field, int offset, String seed) {
            super(EntityPropertyCompletionProposals.getReplacement(field.getElementName(), seed), offset, offset + (seed == null ? 0 : seed.length()), EntityFieldNameCompletionProposal.getFieldImage(field), field.getElementName(), 500);
            this.fieldName = field.getElementName();
        }

        private static Image getFieldImage(IField field) {
            try {
                if (Flags.isPackageDefault((int)field.getFlags())) {
                    return DEFAULT_FIELD;
                }
                if (Flags.isPrivate((int)field.getFlags())) {
                    return PRIVATE_FIELD;
                }
                if (Flags.isProtected((int)field.getFlags())) {
                    return PROTECTED_FIELD;
                }
                if (Flags.isPublic((int)field.getFlags())) {
                    return PUBLIC_FIELD;
                }
            }
            catch (JavaModelException javaModelException) {}
            return null;
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            return "findBy" + StringUtils.capitalize((String)this.fieldName);
        }
    }

    private static class KeyWordCompletionProposal
    extends JavaCompletionProposal {
        public KeyWordCompletionProposal(String keyword, int offset, String seed) {
            super(EntityPropertyCompletionProposals.getReplacement(keyword, seed), offset, offset + keyword.length(), KEYWORD, StringUtils.capitalize((String)keyword), 450);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeywordProposalsProvider {
        private final KeywordProvider provider;

        public KeywordProposalsProvider(KeywordProvider provider) {
            Assert.notNull((Object)provider);
            this.provider = provider;
        }

        public List<ICompletionProposal> getProposalsFor(IType type, int offset, QueryMethodPart part) {
            if (part.isRoot()) {
                return Collections.emptyList();
            }
            String seed = StringUtils.capitalize((String)(part.isKeywordComplete() ? part.getKeyword() : part.getSeed()));
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            for (String keyword : this.provider.getKeywordsForPropertyOf(type, seed)) {
                if (part.isKeywordComplete()) continue;
                proposals.add((ICompletionProposal)new KeyWordCompletionProposal(keyword, offset, seed));
            }
            seed = part.getSeed();
            for (String concatenator : Arrays.asList("And", "Or")) {
                if (!part.isKeywordComplete() && StringUtils.hasText((String)seed) && !concatenator.startsWith(seed)) continue;
                proposals.add((ICompletionProposal)new KeyWordCompletionProposal(concatenator, offset, seed));
            }
            return proposals;
        }
    }
}

