/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansTypedString;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpringDataUtils {
    public static final String NAMESPACE_URI_BASE = "http://www.springframework.org/schema/data";
    private static final Class<?> FACTORY_CLASS = RepositoryFactoryBeanSupport.class;

    public static String getFactoryName() {
        return FACTORY_CLASS.getName();
    }

    public static String getRepositoryInterfaceName(IBean bean) {
        IBeansTypedString property = (IBeansTypedString)bean.getProperty("repositoryInterface").getValue();
        return property.getString();
    }

    public static Set<String> getRepositoryBeanIds(IProject project) {
        HashSet<String> result = new HashSet<String>();
        for (IBean bean : SpringDataUtils.getRepositoryBeansFor(project)) {
            result.add(bean.getElementName());
        }
        return result;
    }

    public static IBean getRepositoryBean(IProject project, String repositoryInterface) {
        for (IBean bean : SpringDataUtils.getRepositoryBeansFor(project)) {
            if (!repositoryInterface.equals(SpringDataUtils.getRepositoryInterfaceName(bean))) continue;
            return bean;
        }
        return null;
    }

    public static boolean isSpringDataElement(Node node) {
        if (1 == node.getNodeType()) {
            String namespaceUri = NamespaceUtils.getNamespaceUri((Element)((Element)node));
            return namespaceUri.startsWith(NAMESPACE_URI_BASE);
        }
        return false;
    }

    public static boolean isRepositoryBean(IBean bean) {
        return bean != null ? bean.getProperty("repositoryInterface") != null : false;
    }

    public static Set<IBean> getRepositoryBeansFor(IProject project) {
        IBeansProject beansProject = BeansCorePlugin.getModel().getProject(project);
        if (beansProject == null) {
            return Collections.emptySet();
        }
        HashSet<IBean> result = new HashSet<IBean>();
        for (IBean bean : BeansModelUtils.getBeans((IModelElement)beansProject)) {
            if (!SpringDataUtils.isRepositoryBean(bean)) continue;
            result.add(bean);
        }
        return result;
    }

    public static Set<IBean> getRepositoryBeansFor(IProject project, IType type) {
        HashSet<IBean> result = new HashSet<IBean>();
        for (IBean bean : SpringDataUtils.getRepositoryBeansFor(project)) {
            if (!type.getFullyQualifiedName().equals(SpringDataUtils.getRepositoryInterfaceName(bean))) continue;
            result.add(bean);
        }
        return result;
    }

    public static boolean hasRepositoryBeanFor(IProject project, IType type) {
        for (IBean bean : SpringDataUtils.getRepositoryBeansFor(project)) {
            if (!type.getFullyQualifiedName().equals(SpringDataUtils.getRepositoryInterfaceName(bean))) continue;
            return true;
        }
        return false;
    }

    public static String asText(IBean bean) {
        if (bean != null) {
            String typeName = SpringDataUtils.isRepositoryBean(bean) ? SpringDataUtils.getRepositoryInterfaceName(bean) : bean.getClassName();
            return String.format("%s [%s]", bean.getElementName(), typeName);
        }
        return "[unknown]";
    }
}

