/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AbstractJavaElementReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdvisedDeclareParentAopReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.ClassBeanReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.util.AopReferenceModelNavigatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMethodReferenceNode
extends AbstractJavaElementReferenceNode
implements IReferenceNode,
IRevealableReferenceNode {
    private List<IReferenceNode> children;
    private List<IReferenceNode> declareParentReferences = new ArrayList<IReferenceNode>();
    private List<IAopReference> declaredOnReferences = new ArrayList<IAopReference>();
    private Set<String> beans = new HashSet<String>();

    public List<IAopReference> getDeclaredOnReferences() {
        return this.declaredOnReferences;
    }

    public List<IReferenceNode> getDeclareParentReferences() {
        return this.declareParentReferences;
    }

    public ClassMethodReferenceNode(IMember member, List<?> children) {
        super(member);
        this.children = children;
    }

    @Override
    public IReferenceNode[] getChildren() {
        ArrayList<IReferenceNode> nodes = new ArrayList<IReferenceNode>();
        if (this.children != null && this.children.size() > 0) {
            nodes.addAll(this.children);
        }
        if (this.getDeclareParentReferences().size() > 0) {
            nodes.addAll(this.getDeclareParentReferences());
        }
        if (this.getDeclaredOnReferences().size() > 0) {
            nodes.add(new AdvisedDeclareParentAopReferenceNode(this.getDeclaredOnReferences()));
        }
        if (this.beans.size() > 0) {
            nodes.add(new ClassBeanReferenceNode(this.beans));
        }
        return nodes.toArray(new IReferenceNode[nodes.size()]);
    }

    @Override
    public String getText() {
        if (this.element instanceof IType) {
            return String.valueOf(AopReferenceModelNavigatorUtils.JAVA_LABEL_PROVIDER.getText((Object)this.element)) + " - " + AopReferenceModelUtils.getPackageLinkName((IJavaElement)this.element);
        }
        return AopReferenceModelNavigatorUtils.JAVA_LABEL_PROVIDER.getText((Object)this.element);
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0 || this.declareParentReferences.size() > 0 || this.declaredOnReferences.size() > 0 || this.beans.size() > 0;
    }

    public void setBeans(Set<String> beans) {
        this.beans = beans;
    }
}

