/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IIntroductionDefinition;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdvisedAopSourceMethodNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.ModelUtils;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class AdvisedAopSourceNode
implements IReferenceNode,
IRevealableReferenceNode {
    private IAopReference references;

    public AdvisedAopSourceNode(IAopReference reference) {
        this.references = reference;
    }

    public IReferenceNode[] getChildren() {
        return new IReferenceNode[]{new AdvisedAopSourceMethodNode(this.references)};
    }

    public Image getImage() {
        IAopReference.ADVICE_TYPE type = this.references.getAdviceType();
        if (type == IAopReference.ADVICE_TYPE.AFTER || type == IAopReference.ADVICE_TYPE.AFTER_RETURNING || type == IAopReference.ADVICE_TYPE.AFTER_THROWING) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.after_advice_obj.gif");
        }
        if (type == IAopReference.ADVICE_TYPE.BEFORE) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.before_advice_obj.gif");
        }
        if (type == IAopReference.ADVICE_TYPE.AROUND) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.around_advice_obj.gif");
        }
        if (type == IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
            return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.introduction_obj.gif");
        }
        return null;
    }

    public String getText() {
        IAopReference.ADVICE_TYPE type = this.references.getAdviceType();
        String text = "";
        if (type == IAopReference.ADVICE_TYPE.AFTER) {
            text = String.valueOf(text) + "after()";
        } else if (type == IAopReference.ADVICE_TYPE.AFTER_RETURNING) {
            text = String.valueOf(text) + "after-returning()";
        } else if (type == IAopReference.ADVICE_TYPE.AFTER_THROWING) {
            text = String.valueOf(text) + "after-throwing()";
        } else if (type == IAopReference.ADVICE_TYPE.BEFORE) {
            text = String.valueOf(text) + "before()";
        } else if (type == IAopReference.ADVICE_TYPE.AROUND) {
            text = String.valueOf(text) + "around()";
        } else if (type == IAopReference.ADVICE_TYPE.DECLARE_PARENTS) {
            text = String.valueOf(text) + "declare parents: implements " + ((IIntroductionDefinition)this.references.getDefinition()).getImplInterfaceName();
        }
        text = String.valueOf(text) + " <";
        text = String.valueOf(text) + this.references.getDefinition().getAspectName();
        text = String.valueOf(text) + "> - ";
        text = String.valueOf(text) + ModelUtils.getFilePath(this.getResource());
        return text;
    }

    public boolean hasChildren() {
        return this.references.getSource() != null;
    }

    public void openAndReveal() {
        IResource resource = this.references.getDefinition().getResource();
        SpringUIUtils.openInEditor((IFile)((IFile)resource), (int)this.references.getDefinition().getAspectStartLineNumber());
    }

    public IAopReference getReference() {
        return this.references;
    }

    public int getLineNumber() {
        return this.references.getDefinition().getAspectStartLineNumber();
    }

    public IResource getResource() {
        return this.references.getResource();
    }

    public Object getReferenceParticipant() {
        return this.references.getDefinition();
    }
}

