/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceDeclareParentAopTargetMethodNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.ModelUtils;
import org.springframework.ide.eclipse.aop.ui.navigator.util.AopReferenceModelNavigatorUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;

public class AdviceDeclareParentAopTargetNode
implements IReferenceNode,
IRevealableReferenceNode {
    private IAopReference reference;

    public AdviceDeclareParentAopTargetNode(IAopReference reference) {
        this.reference = reference;
    }

    public IReferenceNode[] getChildren() {
        return new IReferenceNode[]{new AdviceDeclareParentAopTargetMethodNode(this.reference)};
    }

    public Image getImage() {
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)this.reference.getTargetBeanId());
        if (bean != null) {
            return BeansUIPlugin.getLabelProvider().getImage((Object)bean);
        }
        return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.error_obj.gif");
    }

    public String getText() {
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)this.reference.getTargetBeanId());
        if (bean != null) {
            return String.valueOf(BeansUIPlugin.getLabelProvider().getText((Object)bean)) + " - " + ModelUtils.getFilePath(bean.getElementResource());
        }
        return "<bean cannot be found>";
    }

    public boolean hasChildren() {
        return true;
    }

    public void openAndReveal() {
        IBean bean = AopReferenceModelUtils.getBeanFromElementId((String)this.reference.getTargetBeanId());
        if (bean != null) {
            BeansUIUtils.openInEditor((IResourceModelElement)bean);
        }
    }

    public int getLineNumber() {
        return AopReferenceModelNavigatorUtils.getLineNumber(this.reference.getTarget());
    }

    public IResource getResource() {
        return this.reference.getTarget().getResource();
    }

    public Object getReferenceParticipant() {
        return AopReferenceModelUtils.getBeanFromElementId((String)this.reference.getTargetBeanId());
    }
}

