/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.issue;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.github.core.issue.IssueAttribute;
import org.eclipse.mylyn.internal.github.ui.issue.IssueAttributePart;
import org.eclipse.mylyn.internal.github.ui.issue.IssueSummaryPart;
import org.eclipse.mylyn.internal.github.ui.issue.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueTaskEditorPage
extends AbstractTaskEditorPage {
    public IssueTaskEditorPage(TaskEditor editor) {
        super(editor, "github");
        this.setNeedsPrivateSection(true);
        this.setNeedsSubmitButton(true);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set partDescriptors = super.createPartDescriptors();
        Iterator descriptorIt = partDescriptors.iterator();
        while (descriptorIt.hasNext()) {
            TaskEditorPartDescriptor partDescriptor = (TaskEditorPartDescriptor)descriptorIt.next();
            String id = partDescriptor.getId();
            if (!id.equals("org.eclipse.mylyn.tasks.ui.editors.parts.attributes") && !id.equals("org.eclipse.mylyn.tasks.ui.editors.parts.summary")) continue;
            descriptorIt.remove();
        }
        partDescriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.summary"){

            public AbstractTaskEditorPart createPart() {
                return new IssueSummaryPart(IssueAttribute.REPORTER_GRAVATAR.getMetadata().getId(), IssueAttribute.ASSIGNEE_GRAVATAR.getMetadata().getId());
            }
        }.setPath("header"));
        partDescriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.attributes"){

            public AbstractTaskEditorPart createPart() {
                return new IssueAttributePart();
            }
        }.setPath("attributes"));
        return partDescriptors;
    }

    protected void createParts() {
        super.createParts();
        this.checkCanSubmit(1);
    }

    public void refresh() {
        super.refresh();
        this.checkCanSubmit(1);
    }

    public void doSubmit() {
        if (!this.checkCanSubmit(3)) {
            return;
        }
        super.doSubmit();
    }

    private boolean checkCanSubmit(final int type) {
        final TaskRepository taskRepository = this.getModel().getTaskRepository();
        AuthenticationCredentials cred = taskRepository.getCredentials(AuthenticationType.REPOSITORY);
        if (cred == null || cred.getUserName() == null || cred.getUserName().equals("")) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IssueTaskEditorPage.this.getTaskEditor().setMessage(Messages.IssueTaskEditorPage_MessageAnonymousCannotSubmit, type, (IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            TasksUiUtil.openEditRepositoryWizard((TaskRepository)taskRepository);
                            IssueTaskEditorPage.this.refresh();
                        }
                    });
                }
            });
            return false;
        }
        return true;
    }
}

