/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.cache;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.graph.Activator;
import org.tigris.subversion.subclipse.graph.cache.Branch;
import org.tigris.subversion.subclipse.graph.cache.CacheException;
import org.tigris.subversion.subclipse.graph.cache.Graph;
import org.tigris.subversion.subclipse.graph.cache.LogMessage;
import org.tigris.subversion.subclipse.graph.cache.LogMessageChangePath;
import org.tigris.subversion.subclipse.graph.cache.Node;
import org.tigris.subversion.subclipse.graph.cache.WorkListener;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Cache {
    private static final int MAX_LOG_MESSAGES = 1024;
    private File revisionsFile;
    private File logMessagesFile;
    private File root;
    private List children = new ArrayList();
    private int level;
    private long refreshRevision;
    private RandomAccessFile revisionsRaf = null;
    private RandomAccessFile logMessagesRaf = null;
    private File revisionsTempFile;
    private File logMessagesTempFile;
    private RandomAccessFile revisionsTempRaf = null;
    private RandomAccessFile logMessagesTempRaf = null;
    private List writtenChildren = new ArrayList();

    public Cache(File f, String uuid) {
        this.createDirectory(f);
        f = new File(f, uuid);
        this.createDirectory(f);
        this.root = f;
        this.revisionsFile = new File(this.root, "revisions");
        this.logMessagesFile = new File(this.root, "logMessages");
    }

    public Cache(File f, String uuid, long refreshRevision) {
        this(f, uuid);
        this.refreshRevision = refreshRevision;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(List refreshedNodes, ISVNInfo info, IProgressMonitor monitor, int unitWorked) {
        ISVNLogMessageCallback callback = new ISVNLogMessageCallback(){

            public void singleMessage(ISVNLogMessage message) {
                Cache.this.update(message, true);
            }
        };
        this.revisionsTempFile = new File(this.root, "revisionsTemp");
        this.logMessagesTempFile = new File(this.root, "logMessagesTemp");
        this.revisionsTempFile.delete();
        this.logMessagesTempFile.delete();
        try {
            this.revisionsTempFile.createNewFile();
            this.logMessagesTempFile.createNewFile();
        }
        catch (IOException e) {
            Activator.handleError(e);
        }
        ArrayList<String> revisions = new ArrayList<String>();
        Iterator iter = refreshedNodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            revisions.add(Long.toString(node.getRevision()));
        }
        this.startTempUpdate();
        RandomAccessFile file = null;
        ISVNClientAdapter client = null;
        try {
            try {
                client = SVNProviderPlugin.getPlugin().getSVNClient();
                file = new RandomAccessFile(this.logMessagesFile, "r");
                int revInt = new Long(this.getLatestRevision()).intValue();
                while (file.getFilePointer() < file.length()) {
                    LogMessage lm = this.readNext(file, true);
                    this.level = 0;
                    int index = revisions.indexOf(lm.getRevision().toString());
                    if (index == -1) {
                        this.update(lm, true);
                        if (lm.hasChildren() && lm.getChildMessages() != null) {
                            this.updateChildren(lm, true);
                        }
                        monitor.worked(unitWorked / revInt);
                    } else {
                        Node updateNode = (Node)refreshedNodes.get(index);
                        SVNRevision.Number updateRevision = new SVNRevision.Number(updateNode.getRevision());
                        client.getLogMessages(new SVNUrl(info.getRepository() + updateNode.getPath()), (SVNRevision)updateRevision, (SVNRevision)updateRevision, (SVNRevision)updateRevision, false, true, 0L, true, ISVNClientAdapter.DEFAULT_LOG_PROPERTIES, callback);
                        monitor.worked(unitWorked);
                    }
                    if (!monitor.isCanceled()) continue;
                    break;
                }
            }
            catch (Exception exception) {}
            Object var15_18 = null;
            this.closeFile(file);
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.closeFile(file);
            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
            throw throwable;
        }
        SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
        this.finishTempUpdate();
        if (monitor.isCanceled()) {
            this.revisionsTempFile.delete();
            this.logMessagesTempFile.delete();
            return;
        }
        this.revisionsFile.delete();
        this.logMessagesFile.delete();
        this.revisionsTempFile.renameTo(this.revisionsFile);
        this.logMessagesTempFile.renameTo(this.logMessagesFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(List refreshedMessages, IProgressMonitor monitor, int unitWorked) {
        this.revisionsTempFile = new File(this.root, "revisionsTemp");
        this.logMessagesTempFile = new File(this.root, "logMessagesTemp");
        this.revisionsTempFile.delete();
        this.logMessagesTempFile.delete();
        try {
            this.revisionsTempFile.createNewFile();
            this.logMessagesTempFile.createNewFile();
        }
        catch (IOException e) {
            Activator.handleError(e);
        }
        ArrayList<String> revisions = new ArrayList<String>();
        Iterator iter = refreshedMessages.iterator();
        while (iter.hasNext()) {
            ISVNLogMessage message = (ISVNLogMessage)iter.next();
            revisions.add(message.getRevision().toString());
        }
        this.startTempUpdate();
        RandomAccessFile file = null;
        try {
            try {
                file = new RandomAccessFile(this.logMessagesFile, "r");
                int revInt = new Long(this.getLatestRevision()).intValue();
                while (file.getFilePointer() < file.length()) {
                    LogMessage lm = this.readNext(file, true);
                    this.level = 0;
                    LogMessage updateRevision = null;
                    int index = revisions.indexOf(lm.getRevision().toString());
                    if (index == -1) {
                        updateRevision = lm;
                        monitor.worked(unitWorked / revInt);
                    } else {
                        updateRevision = (ISVNLogMessage)refreshedMessages.get(index);
                        monitor.worked(unitWorked);
                    }
                    this.update(updateRevision, true);
                    if (updateRevision.hasChildren() && updateRevision.getChildMessages() != null) {
                        this.updateChildren(updateRevision, true);
                    }
                    if (!monitor.isCanceled()) continue;
                    break;
                }
            }
            catch (Exception exception) {}
            Object var11_14 = null;
            this.closeFile(file);
            this.finishTempUpdate();
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.closeFile(file);
            throw throwable;
        }
        if (monitor.isCanceled()) {
            this.revisionsTempFile.delete();
            this.logMessagesTempFile.delete();
            return;
        }
        this.revisionsFile.delete();
        this.logMessagesFile.delete();
        this.revisionsTempFile.renameTo(this.revisionsFile);
        this.logMessagesTempFile.renameTo(this.logMessagesFile);
    }

    private void updateChildren(ISVNLogMessage logMessage, boolean writingTempFile) {
        ISVNLogMessage[] childMessages = logMessage.getChildMessages();
        int j = 0;
        while (j < childMessages.length) {
            this.update(childMessages[j], writingTempFile);
            if (childMessages[j].hasChildren() && childMessages[j].getChildMessages() != null) {
                this.updateChildren(childMessages[j], writingTempFile);
            }
            ++j;
        }
        this.update(null, writingTempFile);
    }

    private void createDirectory(File f) {
        if (!f.exists()) {
            if (!f.mkdir()) {
                throw new CacheException("Couldn't create directory: " + f.getAbsolutePath());
            }
        } else if (!f.isDirectory()) {
            throw new CacheException("Should be a directory: " + f.getAbsolutePath());
        }
    }

    public void close() {
        this.closeFile(this.revisionsRaf);
        this.closeFile(this.logMessagesRaf);
    }

    public void startUpdate() {
        this.level = 0;
        try {
            this.revisionsRaf = new RandomAccessFile(this.revisionsFile, "rw");
            this.logMessagesRaf = new RandomAccessFile(this.logMessagesFile, "rw");
            if (this.refreshRevision == 0L) {
                this.revisionsRaf.seek(this.revisionsRaf.length());
                this.logMessagesRaf.seek(this.logMessagesRaf.length());
            }
        }
        catch (IOException e) {
            throw new CacheException("Error while opening file", e);
        }
    }

    public void startTempUpdate() {
        this.level = 0;
        try {
            this.revisionsTempRaf = new RandomAccessFile(this.revisionsTempFile, "rw");
            this.logMessagesTempRaf = new RandomAccessFile(this.logMessagesTempFile, "rw");
        }
        catch (IOException e) {
            throw new CacheException("Error while opening file", e);
        }
    }

    private String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private void writeLogMessage(ISVNLogMessage logMessage, int level, boolean writingTempFile) throws IOException {
        RandomAccessFile revRaf = null;
        RandomAccessFile logRaf = null;
        if (writingTempFile) {
            revRaf = this.revisionsTempRaf;
            logRaf = this.logMessagesTempRaf;
        } else {
            revRaf = this.revisionsRaf;
            logRaf = this.logMessagesRaf;
        }
        long revision = logMessage.getRevision().getNumber();
        long fp = logRaf.getFilePointer();
        revRaf.writeLong(fp);
        logRaf.writeLong(revision);
        logRaf.writeLong(logMessage.getDate().getTime());
        logRaf.writeUTF(this.notNull(logMessage.getAuthor()));
        String message = this.notNull(logMessage.getMessage());
        if (message.length() > 64000) {
            message = String.valueOf(message.substring(0, 64397)) + "...";
        }
        logRaf.writeUTF(message);
        ISVNLogMessageChangePath[] changePaths = logMessage.getChangedPaths();
        logRaf.writeInt(changePaths.length);
        int cc = 0;
        if (changePaths.length > 1) {
            String a = changePaths[0].getPath();
            String b = null;
            int i = 1;
            while (i < changePaths.length) {
                b = changePaths[i].getPath();
                cc = Cache.commonChars(a, b, cc);
                a = b;
                ++i;
            }
            logRaf.writeUTF(a.substring(0, cc));
        }
        int i = 0;
        while (i < changePaths.length) {
            ISVNLogMessageChangePath changePath = changePaths[i];
            logRaf.writeChar(changePath.getAction());
            logRaf.writeUTF(changePath.getPath().substring(cc));
            long copySrcRevision = 0L;
            if (changePath.getCopySrcRevision() != null && changePath.getCopySrcPath() != null) {
                copySrcRevision = changePath.getCopySrcRevision().getNumber();
                logRaf.writeLong(copySrcRevision);
                logRaf.writeUTF(changePath.getCopySrcPath());
            } else {
                logRaf.writeLong(copySrcRevision);
            }
            ++i;
        }
        if (level == 0 && !logMessage.hasChildren()) {
            logRaf.writeInt(0);
        }
    }

    public void finishUpdate() {
        this.closeFile(this.revisionsRaf);
        this.closeFile(this.logMessagesRaf);
        this.revisionsRaf = null;
        this.logMessagesRaf = null;
    }

    public void finishTempUpdate() {
        this.closeFile(this.revisionsTempRaf);
        this.closeFile(this.logMessagesTempRaf);
        this.revisionsTempRaf = null;
        this.logMessagesTempRaf = null;
    }

    public void update(ISVNLogMessage logMessage) {
        this.update(logMessage, false);
    }

    public void update(ISVNLogMessage logMessage, boolean writingTempFile) {
        try {
            if (logMessage == null) {
                if (this.level == 1) {
                    this.writeChildren(this.level, writingTempFile);
                    this.children.clear();
                }
                --this.level;
            } else {
                if (this.level == 1) {
                    this.children.add(logMessage);
                } else if (this.level == 0) {
                    this.writeLogMessage(logMessage, this.level, writingTempFile);
                }
                if (logMessage.hasChildren()) {
                    ++this.level;
                }
            }
        }
        catch (IOException e) {
            throw new CacheException("Error while saving log message", e);
        }
    }

    private void writeChildren(int level, boolean writingTempFile) throws IOException {
        List nonWrittenChildren = this.getNonWrittenChildren();
        if (writingTempFile) {
            this.logMessagesTempRaf.writeInt(nonWrittenChildren.size());
        } else {
            this.logMessagesRaf.writeInt(nonWrittenChildren.size());
        }
        Iterator it = nonWrittenChildren.iterator();
        while (it.hasNext()) {
            ISVNLogMessage logMessage = (ISVNLogMessage)it.next();
            this.writeLogMessage(logMessage, level, writingTempFile);
        }
    }

    private List getNonWrittenChildren() {
        ArrayList<ISVNLogMessage> nonWrittenChildren = new ArrayList<ISVNLogMessage>();
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            ISVNLogMessage logMessage = (ISVNLogMessage)it.next();
            if (this.writtenChildren.contains(logMessage.getRevision().toString())) continue;
            nonWrittenChildren.add(logMessage);
            this.writtenChildren.add(logMessage.getRevision().toString());
        }
        return nonWrittenChildren;
    }

    public long getLatestRevision() {
        return this.revisionsFile.length() / 8L;
    }

    public void readNext(RandomAccessFile file, ISVNLogMessage[] buffer, int number) {
        do {
            buffer[--number] = this.readNext(file, true);
        } while (number > 0);
    }

    /*
     * Exception decompiling
     */
    public Node findRootNode(String path, long revision, WorkListener listener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 372->375)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LogMessage readNext(RandomAccessFile file, boolean nested) {
        try {
            int children;
            long revision = file.readLong();
            long date = file.readLong();
            String author = file.readUTF();
            String message = file.readUTF();
            LogMessage logMessage = new LogMessage(revision, author, new Date(date), message);
            int length = file.readInt();
            String cp = "";
            if (length > 1) {
                cp = file.readUTF();
            }
            LogMessageChangePath[] changedPaths = new LogMessageChangePath[length];
            logMessage.setChangedPaths(changedPaths);
            int i = 0;
            while (i < length) {
                char action = file.readChar();
                String path = String.valueOf(cp) + file.readUTF();
                long copySrcRevision = file.readLong();
                String copySrcPath = null;
                if (copySrcRevision > 0L) {
                    copySrcPath = file.readUTF();
                }
                changedPaths[i] = new LogMessageChangePath(action, path, copySrcPath, copySrcRevision);
                ++i;
            }
            if (nested && (children = file.readInt()) > 0) {
                LogMessage[] childMessages = new LogMessage[children];
                int i2 = 0;
                while (i2 < children) {
                    childMessages[i2] = this.readNext(file, false);
                    ++i2;
                }
                logMessage.setChildMessages(childMessages);
            }
            return logMessage;
        }
        catch (IOException e) {
            throw new CacheException("Error while reading log messages from file", e);
        }
    }

    public long getSeek(long revision) {
        RandomAccessFile file = null;
        try {
            long seek;
            file = new RandomAccessFile(this.revisionsFile, "r");
            file.seek((revision - 1L) * 8L);
            long l = seek = file.readLong();
            Object var6_6 = null;
            this.closeFile(file);
            return l;
        }
        catch (IOException e) {
            try {
                throw new CacheException("Error while reading revisions file", e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.closeFile(file);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Graph createGraph(String rootPath, long revision, WorkListener listener) {
        Iterator iter;
        Graph graph = new Graph(rootPath);
        graph.addBranch(rootPath);
        long seek = this.getSeek(revision);
        RandomAccessFile file = null;
        try {
            try {
                file = new RandomAccessFile(this.logMessagesFile, "r");
                file.seek(seek);
                while (file.getFilePointer() < file.length()) {
                    block23: {
                        int i;
                        ISVNLogMessage[] cm;
                        LogMessage lm = this.readNext(file, true);
                        ISVNLogMessageChangePath[] changedPaths = lm.getChangedPaths();
                        String[] pa = graph.getPathsAsArray();
                        Node node = null;
                        int n = 0;
                        block6: while (true) {
                            if (n >= changedPaths.length) {
                                if (node != null && lm.hasChildren()) {
                                    cm = lm.getChildMessages();
                                    i = 0;
                                    break;
                                }
                                break block23;
                            }
                            ISVNLogMessageChangePath cp = changedPaths[n];
                            String nodePath = cp.getPath();
                            String copySrcPath = cp.getCopySrcPath();
                            int i2 = 0;
                            while (true) {
                                block25: {
                                    Node source;
                                    Branch branch;
                                    String branchPath;
                                    block24: {
                                        if (i2 >= pa.length) {
                                            ++n;
                                            continue block6;
                                        }
                                        branchPath = pa[i2];
                                        if (copySrcPath != null) break block24;
                                        if ((cp.getAction() == 'A' && nodePath.equals(branchPath) || cp.getAction() == 'D' && Cache.isEqualsOrParent(nodePath, branchPath) || cp.getAction() == 'M' && nodePath.equals(branchPath)) && !(branch = graph.getBranch(branchPath)).isEnded()) {
                                            node = this.toNode(lm, cp);
                                            node.setParent(branch.getLastNode());
                                            branch.addNode(node);
                                            if (node.getAction() == 'D') {
                                                branch.end();
                                            }
                                        }
                                        break block25;
                                    }
                                    if (copySrcPath != null && Cache.isEqualsOrParent(copySrcPath, branchPath) && (source = (branch = graph.getBranch(branchPath)).getSource(cp.getCopySrcRevision().getNumber())) != null) {
                                        node = this.toNode(lm, cp);
                                        node.setSource(source);
                                        String path = String.valueOf(nodePath) + branchPath.substring(copySrcPath.length());
                                        Branch newBranch = graph.getBranch(path);
                                        if (newBranch == null) {
                                            newBranch = graph.addBranch(path);
                                        }
                                        newBranch.addNode(node);
                                    }
                                }
                                ++i2;
                            }
                            break;
                        }
                        block8: while (i < cm.length) {
                            ISVNLogMessage child = cm[i];
                            ISVNLogMessageChangePath[] cp = child.getChangedPaths();
                            int j = 0;
                            block9: while (true) {
                                if (j >= cp.length) {
                                    ++i;
                                    continue block8;
                                }
                                ISVNLogMessageChangePath changePath = cp[j];
                                int k = 0;
                                while (true) {
                                    Branch branch;
                                    Node source;
                                    if (k >= pa.length) {
                                        ++j;
                                        continue block9;
                                    }
                                    String path = pa[k];
                                    if (path.equals(changePath.getPath()) && (source = (branch = graph.getBranch(path)).getSource(child.getRevision().getNumber())) != null) {
                                        node.addMergedRevision(source);
                                    }
                                    ++k;
                                }
                                break;
                            }
                        }
                    }
                    if (listener == null) continue;
                    listener.worked();
                }
            }
            catch (IOException e) {
                throw new CacheException("Error while calculating graph", e);
            }
        }
        catch (Throwable throwable) {
            Object var23_27 = null;
            this.closeFile(file);
            throw throwable;
        }
        {
            Object var23_28 = null;
            this.closeFile(file);
            List paths = graph.getPaths();
            iter = paths.iterator();
        }
        while (iter.hasNext()) {
            Node firstNode;
            String path = (String)iter.next();
            Branch branch = graph.getBranch(path);
            if (branch.getNodes().size() != 1 || (firstNode = (Node)branch.getNodes().iterator().next()).getSource() == null || firstNode.getChildCount() != 0 || firstNode.getSource() == null) continue;
            firstNode.getSource().addTag(firstNode);
        }
        return graph;
    }

    public Node toNode(ISVNLogMessage lm, ISVNLogMessageChangePath cp) {
        Node node = new Node();
        node.setAction(cp.getAction());
        node.setAuthor(lm.getAuthor());
        node.setCopySrcPath(cp.getCopySrcPath());
        node.setCopySrcRevision(cp.getCopySrcRevision().getNumber());
        node.setMessage(lm.getMessage());
        node.setPath(cp.getPath());
        node.setRevision(lm.getRevision().getNumber());
        node.setRevisionDate(lm.getDate());
        return node;
    }

    private static int commonChars(String a, String b, int max) {
        int i = 0;
        int ml = max > 0 ? max : a.length();
        if (b.length() < ml) {
            ml = b.length();
        }
        while (i < ml) {
            if (a.charAt(i) != b.charAt(i)) break;
            ++i;
        }
        return i;
    }

    public static void main(String[] args) {
    }

    public static boolean isEqualsOrParent(String parent, String path) {
        if (parent.length() == path.length()) {
            return parent.equals(path);
        }
        return path.startsWith(String.valueOf(parent) + "/");
    }

    public void clearCache() {
        this.deleteFile(this.revisionsFile);
        this.deleteFile(this.logMessagesFile);
    }

    public static File getCacheDirectory(IResource resource) {
        File f = resource == null ? ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toFile() : resource.getWorkspace().getRoot().getRawLocation().toFile();
        f = new File(f, ".metadata");
        f = new File(f, ".plugins");
        f = new File(f, "org.tigris.subversion.subclipse.graph");
        return f;
    }

    private void deleteFile(File f) {
        if (f.exists() && !f.delete()) {
            System.err.println("Couldn't delete file: " + f.getAbsolutePath());
        }
    }

    private void closeFile(RandomAccessFile file) {
        if (file == null) {
            return;
        }
        try {
            file.close();
        }
        catch (IOException e) {
            throw new CacheException("Error while closing file", e);
        }
    }
}

