/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.configurator.server;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatWebModule;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.InstallableRuntime2;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.fragment.LicenseWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.springsource.ide.eclipse.commons.configurator.ServerHandler;
import org.springsource.ide.eclipse.commons.configurator.ServerHandlerCallback;
import org.springsource.ide.eclipse.commons.core.HttpUtil;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.internal.configurator.ConfiguratorImporter;
import org.springsource.ide.eclipse.commons.internal.configurator.server.ServerDescriptor;
import org.springsource.ide.eclipse.commons.ui.UiUtil;

public class ServerConfigurator {
    public static final String RESOURCE_DOWNLOAD_DM_SERVER_1 = "download.dm.server.1";
    public static final String RESOURCE_DOWNLOAD_DM_SERVER_2 = "download.dm.server.2";
    public static final String RESOURCE_DOWNLOAD_TOMCAT_6 = "download.tomcat.6";
    public static String ID_DM_SERVER_1 = "com.springsource.sts.ide.configurator.server.DmServer1";
    public static String ID_DM_SERVER_2 = "com.springsource.sts.ide.configurator.server.DmServer2";
    public static String ID_CF_SERVER = "com.springsource.sts.ide.configurator.server.CfServer";
    public static String ID_TOMCAT = "com.springsource.sts.ide.configurator.server.Tomcat";
    public List<ServerDescriptor> descriptors = new ArrayList<ServerDescriptor>();
    private ConfiguratorImporter configurator;

    public ServerConfigurator() {
        ServerDescriptor dmServer1 = new ServerDescriptor(ID_DM_SERVER_1);
        dmServer1.setArchivePath("springsource-dm-server-1.0.2.SR02");
        dmServer1.setRuntimeTypeId("com.springsource.server.runtime.10");
        dmServer1.setServerTypeId("com.springsource.server.10");
        dmServer1.setRuntimeName("SpringSource dm Server (Runtime) v1.0");
        dmServer1.setServerName("SpringSource dm Server v1.0");
        dmServer1.setName("SpringSource dm Server");
        dmServer1.setDescription("SpringSource dm Server is an open source, completely modular, OSGi-based Java server designed to run enterprise Java applications and Spring-powered application.");
        dmServer1.setInstallPath("dm-server-1");
        dmServer1.setVersionRange("[1.0.0,2.0.0)");
        dmServer1.setBundleId("com.springsource.server.dm.bundle-v1");
        this.addDescriptor(dmServer1);
        ServerDescriptor dmServer2 = new ServerDescriptor(ID_DM_SERVER_2);
        dmServer2.setArchivePath("springsource-dm-server-2.0.0.RELEASE");
        dmServer2.setRuntimeTypeId("com.springsource.server.runtime.20");
        dmServer2.setServerTypeId("com.springsource.server.20");
        dmServer2.setRuntimeName("SpringSource dm Server (Runtime) v2.0");
        dmServer2.setServerName("SpringSource dm Server v2.0");
        dmServer2.setName("SpringSource dm Server");
        dmServer2.setDescription("SpringSource dm Server is an open source, completely modular, OSGi-based Java server designed to run enterprise Java applications and Spring-powered application.");
        dmServer2.setInstallPath("dm-server-2");
        dmServer2.setVersionRange("[2.0.0,3.0.0)");
        dmServer2.setBundleId("com.springsource.server.dm.bundle-v2");
        this.addDescriptor(dmServer2);
        ServerDescriptor cfServer = new ServerDescriptor(ID_CF_SERVER);
        cfServer.setRuntimeTypeId("com.springsource.cloudfoundryserver.runtime.10");
        cfServer.setServerTypeId("com.springsource.cloudfoundryserver.10");
        cfServer.setRuntimeName("SpringSource Cloud Foundry (Runtime) v1.0");
        cfServer.setServerName("SpringSource Cloud Foundry v1.0");
        cfServer.setName("SpringSource Cloud Foundry Server");
        cfServer.setDescription("Publishes and runs J2EE Web projects to Cloud Foundry.");
        cfServer.setForceCreateRuntime(true);
        cfServer.setAutoConfigurable(false);
        this.addDescriptor(cfServer);
        ServerDescriptor tomcatServer = new ServerDescriptor(ID_TOMCAT);
        tomcatServer.setRuntimeTypeId("org.eclipse.jst.server.tomcat.runtime.60");
        tomcatServer.setServerTypeId("org.eclipse.jst.server.tomcat.60");
        tomcatServer.setRuntimeName("Apache Tomcat (Runtime) v6.0");
        tomcatServer.setServerName("Apache Tomcat v6.0");
        tomcatServer.setName("Apache Tomcat");
        tomcatServer.setDescription("Apache Tomcat supports J2EE 1.2, 1.3, 1.4, and Java EE 5.");
        tomcatServer.setVersionRange("[6.0.0,7.0.0)");
        tomcatServer.setInstallPath("apache-tomcat-6.0");
        tomcatServer.setBundleId("org.apache.tomcat.bundle");
        tomcatServer.setCallback(new ServerHandlerCallback(){

            @Override
            public void configureServer(IServerWorkingCopy server) {
                try {
                    TomcatServer ts = (TomcatServer)server.loadAdapter(TomcatServer.class, null);
                    TomcatConfiguration configuration = ts.getTomcatConfiguration();
                    String docBase = server.getRuntime().getLocation().append("webapps").append("manager").toOSString();
                    WebModule managerModule = new WebModule("/manager", docBase, null, false);
                    configuration.addWebModule(-1, (ITomcatWebModule)managerModule);
                    Field field = configuration.getClass().getDeclaredField("serverInstance");
                    field.setAccessible(true);
                    ServerInstance serverInstance = (ServerInstance)field.get(configuration);
                    Context context = serverInstance.getContext("/manager");
                    if (context != null) {
                        context.setAttributeValue("privileged", "true");
                    }
                }
                catch (LinkageError linkageError) {
                }
                catch (Exception exception) {}
            }
        });
        this.addDescriptor(tomcatServer);
        Set<ServerDescriptor> items = ServerDescriptorExtensionPointReader.getDescriptors();
        for (ServerDescriptor item : items) {
            this.addDescriptor(item);
        }
    }

    private void addDescriptor(ServerDescriptor descriptor) {
        if (ServerCore.findRuntimeType((String)descriptor.getRuntimeTypeId()) == null) {
            return;
        }
        this.descriptors.add(descriptor);
    }

    public ServerDescriptor getDescriptor(String id) {
        for (ServerDescriptor descriptor : this.descriptors) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    public ServerDescriptor getDescriptorByBundleId(String id) {
        Assert.isNotNull((Object)id);
        for (ServerDescriptor descriptor : this.descriptors) {
            if (!id.equals(descriptor.getBundleId())) continue;
            return descriptor;
        }
        return null;
    }

    public List<ServerDescriptor> getDescriptors() {
        return Collections.unmodifiableList(this.descriptors);
    }

    public File getLocation(ServerDescriptor descriptor) {
        List<File> locations = this.getConfigurator().scan(descriptor.getInstallPath(), new VersionRange(descriptor.getVersionRange()));
        return locations.size() > 0 ? locations.iterator().next() : null;
    }

    public Set<String> getInstalledBundles() {
        HashSet<String> installedBundles = new HashSet<String>();
        for (ServerDescriptor descriptor : this.descriptors) {
            if (descriptor.getBundleId() == null || this.getLocation(descriptor) == null) continue;
            installedBundles.add(descriptor.getBundleId());
        }
        return installedBundles;
    }

    public ServerHandler installServer(final ServerDescriptor descriptor, File installLocation, IOverwriteQuery query, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
            progress.beginTask(NLS.bind((String)"Installing Runtime {0}", (Object)descriptor.getRuntimeName()), 100);
            File serverLocation = this.getLocation(descriptor);
            if (serverLocation == null) {
                final boolean[] response = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        response[0] = MessageDialog.openQuestion((Shell)UiUtil.getShell(), (String)"Install Runtime", (String)NLS.bind((String)"No local installation of {0} found. Proceed with download?", (Object)descriptor.getServerName()));
                    }
                });
                if (!response[0]) {
                    throw new OperationCanceledException();
                }
                ServerDescriptorInstaller ir = new ServerDescriptorInstaller(descriptor);
                if (ir.getLicenseURL() != null) {
                    progress.subTask("Downloading license");
                    try {
                        final boolean[] result = new boolean[1];
                        final String license = ir.getLicense((IProgressMonitor)progress.newChild(20));
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                TaskModel taskModel = new TaskModel();
                                taskModel.putObject("license", (Object)license);
                                TaskWizard wizard2 = new TaskWizard("License", new WizardFragment(){

                                    protected void createChildFragments(List list) {
                                        list.add(new LicenseWizardFragment());
                                    }
                                }, taskModel);
                                WizardDialog dialog2 = new WizardDialog(UiUtil.getShell(), (IWizard)wizard2);
                                result[0] = dialog2.open() == 0;
                            }
                        });
                        if (!result[0]) {
                            throw new OperationCanceledException();
                        }
                    }
                    catch (CoreException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.configurator", "Error getting license", (Throwable)e));
                    }
                }
                progress.setWorkRemaining(80);
                serverLocation = new File(installLocation, descriptor.getInstallPath());
                monitor.subTask(NLS.bind((String)"Downloading runtime to {0}", (Object)serverLocation.getAbsolutePath()));
                File archiveFile = File.createTempFile("runtime", null);
                archiveFile.deleteOnExit();
                HttpUtil.download((String)descriptor.getArchiveUrl(), (File)archiveFile, (File)serverLocation, (String)descriptor.getArchivePath(), (IProgressMonitor)progress.newChild(70));
            }
            progress.setWorkRemaining(10);
            monitor.subTask(NLS.bind((String)"Creating server {0}", (Object)descriptor.getServerName()));
            ServerHandler serverHandler = new ServerHandler(descriptor, serverLocation);
            serverHandler.createServer((IProgressMonitor)progress.newChild(10), query, descriptor.getCallback());
            ServerHandler serverHandler2 = serverHandler;
            return serverHandler2;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.configurator", "Installing runtime failed", (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    public ConfiguratorImporter getConfigurator() {
        if (this.configurator == null) {
            this.configurator = new ConfiguratorImporter();
        }
        return this.configurator;
    }

    public ServerHandler installServer(ServerDescriptor descriptor, IOverwriteQuery query, IProgressMonitor monitor) throws CoreException {
        File installLocation = this.getConfigurator().getInstallLocation();
        if (installLocation == null) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.configurator", "Unable to determine writeable location for installing runtime."));
        }
        return this.installServer(descriptor, installLocation, query, monitor);
    }

    public boolean isInstalled(String bundleId) {
        ServerDescriptor descriptor = this.getDescriptorByBundleId(bundleId);
        if (descriptor != null) {
            return this.getLocation(descriptor) != null;
        }
        return false;
    }

    public void setDescriptors(List<ServerDescriptor> descriptors) {
        this.descriptors = new ArrayList<ServerDescriptor>(descriptors);
    }

    public static class ServerDescriptorExtensionPointReader {
        private static final String ELEMENT_RUNTIME = "runtime";
        private static final String EXTENSION_ID = "com.springsource.sts.ide.configurator.serverConfigurations";

        public static Set<ServerDescriptor> getDescriptors() {
            IExtension[] extensions;
            HashSet<ServerDescriptor> items = new HashSet<ServerDescriptor>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    ServerDescriptor item;
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(ELEMENT_RUNTIME) && (item = new ServerDescriptor(element)).isValid()) {
                        items.add(item);
                    }
                    ++n4;
                }
                ++n2;
            }
            return items;
        }
    }

    private class ServerDescriptorInstaller
    extends InstallableRuntime2 {
        private final ServerDescriptor descriptor;

        public ServerDescriptorInstaller(ServerDescriptor descriptor) {
            super(null);
            this.descriptor = descriptor;
        }

        public String getArchivePath() {
            return this.descriptor.getArchivePath();
        }

        public String getArchiveUrl() {
            return this.descriptor.getArchiveUrl();
        }

        public String getId() {
            return this.descriptor.getRuntimeTypeId();
        }

        public String getLicenseURL() {
            return this.descriptor.getLicenseUrl();
        }

        public String getName() {
            return this.descriptor.getRuntimeName();
        }
    }
}

