/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.configurator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.springsource.ide.eclipse.commons.configurator.WorkspaceConfiguratorParticipant;

public class ParticipantDescriptor {
    private String label;
    private String location;
    private final String id;
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LABEL = "label";
    private final IConfigurationElement element;

    public ParticipantDescriptor(IConfigurationElement element) {
        this.element = element;
        String id = element.getAttribute(ATTR_ID);
        if (id == null) {
            id = element.getAttribute(ATTR_CLASS);
        }
        this.id = id;
        String label = element.getAttribute(ATTR_LABEL);
        if (label == null) {
            label = id;
        }
        this.label = label;
    }

    public ParticipantDescriptor(String id) {
        this.id = id;
        this.element = null;
    }

    public WorkspaceConfiguratorParticipant createConfigurator() {
        if (this.element != null) {
            try {
                Object object = WorkbenchPlugin.createExtension((IConfigurationElement)this.element, (String)ATTR_CLASS);
                if (object instanceof WorkspaceConfiguratorParticipant) {
                    WorkspaceConfiguratorParticipant participant = (WorkspaceConfiguratorParticipant)object;
                    participant.setId(this.getId());
                    return participant;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

