/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.configurator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.springsource.ide.eclipse.commons.core.CoreUtil;
import org.springsource.ide.eclipse.commons.internal.configurator.operations.AbstractInstallOperation;
import org.springsource.ide.eclipse.commons.internal.configurator.operations.ChmodOperation;
import org.springsource.ide.eclipse.commons.internal.configurator.operations.CopyOperation;

public class InstallableItem {
    private static final String ATTR_CONFIGURATOR = "configurator";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_TARGET = "target";
    private static final String ELEMENT_CHMOD = "chmod";
    private static final String ELEMENT_COPY = "copy";
    private final IConfigurationElement element;
    private final String id;
    private String name;

    private static String readId(IConfigurationElement element) {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        String id = element.getAttribute(ATTR_ID);
        if (id == null) {
            id = String.valueOf(bundle.getSymbolicName()) + "-" + bundle.getVersion();
        } else {
            Properties properties = new Properties();
            properties.setProperty("package", bundle.getSymbolicName());
            properties.setProperty("version", bundle.getVersion().toString());
            id = CoreUtil.substitute((String)id, (Properties)properties);
        }
        return id;
    }

    public InstallableItem(IConfigurationElement element) {
        this.id = InstallableItem.readId(element);
        this.element = element;
        String label = element.getAttribute(ATTR_LABEL);
        if (label != null) {
            this.setName(label);
        } else {
            Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
            this.setName((String)bundle.getHeaders().get("Bundle-Name"));
        }
    }

    public String getConfiguratorId() {
        return this.element.getAttribute(ATTR_CONFIGURATOR);
    }

    public String getTarget() {
        String target = this.element.getAttribute(ATTR_TARGET);
        if (target == null) {
            return this.getId();
        }
        return target;
    }

    public String getId() {
        return this.id;
    }

    public List<AbstractInstallOperation> getInstallOperations() {
        IConfigurationElement[] elements = this.element.getChildren();
        ArrayList<AbstractInstallOperation> operations = new ArrayList<AbstractInstallOperation>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(ELEMENT_COPY)) {
                operations.add(new CopyOperation(element));
            } else if (element.getName().equals(ELEMENT_CHMOD)) {
                operations.add(new ChmodOperation(element));
            }
            ++n2;
        }
        return operations;
    }

    public String getName() {
        return this.name;
    }

    public IStatus install(File base, IProgressMonitor monitor) {
        File targetLocation = this.getTargetLocation(base);
        targetLocation.mkdirs();
        MultiStatus result = new MultiStatus("org.springsource.ide.eclipse.commons.configurator", 0, NLS.bind((String)"Installation of {0} failed", (Object)this.getName()), null);
        List<AbstractInstallOperation> operations = this.getInstallOperations();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Installing {0}", (Object)this.getName()), (int)operations.size());
        for (AbstractInstallOperation operation : operations) {
            try {
                operation.setSourceBase(this.getSourceLocation());
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            operation.setTargetBase(targetLocation);
            IStatus status = operation.install((IProgressMonitor)progress.newChild(1));
            result.add(status);
        }
        return result;
    }

    public File getTargetLocation(File base) {
        return new File(base, this.getTarget());
    }

    public boolean isInstallable() {
        return this.getInstallOperations().size() > 0;
    }

    public void setName(String name) {
        this.name = name;
    }

    private File getSourceLocation() throws CoreException {
        Bundle bundle = Platform.getBundle((String)this.element.getContributor().getName());
        try {
            return FileLocator.getBundleFile((Bundle)bundle);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.configurator", "Failed to determine install location", (Throwable)e));
        }
    }
}

