/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.configurator;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.springsource.ide.eclipse.commons.internal.configurator.InstallableItem;

public abstract class ConfigurableExtension {
    private boolean autoConfigurable;
    private boolean configured;
    private final String id;
    private InstallableItem installableItem;
    private String label;
    private String location;

    public ConfigurableExtension(String id) {
        Assert.isNotNull((Object)id);
        this.id = id;
    }

    public abstract IStatus configure(IProgressMonitor var1);

    public String getBundleId() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public InstallableItem getInstallableItem() {
        return this.installableItem;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLocation() {
        return this.location;
    }

    public IStatus install(File targetDir, IProgressMonitor monitor) {
        return this.getInstallableItem().install(targetDir, monitor);
    }

    public boolean isAutoConfigurable() {
        return this.autoConfigurable;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public boolean isInstallable() {
        return this.installableItem != null;
    }

    public void postConfiguration(IStatus result) {
    }

    public void setAutoConfigurable(boolean autoConfigurable) {
        this.autoConfigurable = autoConfigurable;
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public void setInstallableItem(InstallableItem installableItem) {
        this.installableItem = installableItem;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String toString() {
        return "ConfigurableExtension [id=" + this.id + ", autoConfigurable=" + this.autoConfigurable + ", configured=" + this.configured + ", location=" + this.location + "]";
    }

    public abstract IStatus unConfigure(IProgressMonitor var1);
}

