/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.wizards;

import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.testng.eclipse.util.StringUtils;
import org.testng.eclipse.util.SuiteGenerator;
import org.testng.eclipse.util.Utils;
import org.testng.eclipse.wizards.NewTestNGClassWizardPage;
import org.testng.eclipse.wizards.TestNGMethodWizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewTestNGClassWizard
extends Wizard
implements INewWizard {
    private NewTestNGClassWizardPage m_page;
    private TestNGMethodWizardPage m_methodPage;

    public NewTestNGClassWizard() {
        this.setNeedsProgressMonitor(true);
    }

    private boolean hasAtLeastOneMethod(List<Utils.JavaElement> elements) {
        for (Utils.JavaElement je : elements) {
            if (je.compilationUnit == null) continue;
            return true;
        }
        return false;
    }

    public void addPages() {
        List<Utils.JavaElement> elements = Utils.getSelectedJavaElements();
        if (this.hasAtLeastOneMethod(elements)) {
            this.m_methodPage = new TestNGMethodWizardPage(elements);
            this.addPage((IWizardPage)this.m_methodPage);
        }
        this.m_page = new NewTestNGClassWizardPage();
        this.addPage((IWizardPage)this.m_page);
    }

    public boolean performFinish() {
        String containerName = this.m_page.getSourceFolder();
        String className = this.m_page.getClassName();
        String packageName = this.m_page.getPackageName();
        List<IMethod> methods = this.m_methodPage != null ? this.m_methodPage.getSelectedMethods() : Collections.emptyList();
        try {
            return this.doFinish(containerName, packageName, className, this.m_page.getXmlFile(), methods, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return true;
        }
    }

    private boolean doFinish(String containerName, String packageName, String className, String xmlPath, List<IMethod> methods, IProgressMonitor monitor) throws CoreException {
        IFile file;
        boolean result = true;
        if (!StringUtils.isEmptyString(xmlPath)) {
            file = this.createFile(containerName, "", xmlPath, this.createXmlContentStream(), monitor);
            if (file != null) {
                Utils.openFile(this.getShell(), file, monitor);
            } else {
                result = false;
            }
        }
        if (result) {
            file = this.createFile(containerName, packageName, String.valueOf(className) + ".java", this.createJavaContentStream(className, methods), monitor);
            if (file != null) {
                Utils.openFile(this.getShell(), file, monitor);
            } else {
                result = false;
            }
        }
        return result;
    }

    private IFile createFile(String containerName, String packageName, String fileName, InputStream contentStream, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String fullPath = fileName;
        if (packageName != null && !"".equals(packageName)) {
            fullPath = String.valueOf(packageName.replace(".", File.separator)) + File.separatorChar + fileName;
        }
        Path absolutePath = new Path(String.valueOf(containerName) + File.separatorChar + fullPath);
        IFile result = root.getFile((IPath)absolutePath);
        org.testng.eclipse.ui.util.Utils.createFileWithDialog(this.getShell(), result, contentStream);
        return result;
    }

    private InputStream createJavaContentStream(String className, List<IMethod> testMethods) {
        StringBuilder imports = new StringBuilder("import org.testng.annotations.Test;\n");
        StringBuilder methods = new StringBuilder();
        String dataProvider = "";
        String signature = "()";
        String[] stringArray = NewTestNGClassWizardPage.ANNOTATIONS;
        int n = NewTestNGClassWizardPage.ANNOTATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (!"".equals(a) && this.m_page.containsAnnotation(a)) {
                imports.append("import org.testng.annotations." + a + ";\n");
                if ("DataProvider".equals(a)) {
                    dataProvider = "(dataProvider = \"dp\")";
                    methods.append("\n  @DataProvider\n  public Object[][] dp() {\n    return new Object[][] {\n      new Object[] { 1, \"a\" },\n      new Object[] { 2, \"b\" },\n    };\n  }\n");
                    signature = "(Integer n, String s)";
                } else {
                    methods.append("  @" + a + "\n" + "  public void " + this.toMethod(a) + "() {\n" + "  }\n\n");
                }
            }
            ++n2;
        }
        HashSet overloadedMethods = Sets.newHashSet();
        HashSet temp = Sets.newHashSet();
        for (IMethod m : testMethods) {
            String name = m.getElementName();
            if (temp.contains(name)) {
                overloadedMethods.add(name);
            }
            temp.add(name);
        }
        for (IMethod m : testMethods) {
            methods.append("\n  @Test\n  public void " + this.createSignature(m, overloadedMethods) + " {\n" + "    throw new RuntimeException(\"Test not implemented\");\n" + "  }\n");
        }
        String contents = "package " + this.m_page.getPackage() + ";\n\n" + imports + "\n" + "public class " + className + " {\n";
        if (testMethods.size() == 0 || !StringUtils.isEmptyString(dataProvider)) {
            contents = String.valueOf(contents) + "  @Test" + dataProvider + "\n" + "  public void f" + signature + " {\n" + "  }\n";
        }
        contents = String.valueOf(contents) + methods + "}\n";
        return new ByteArrayInputStream(contents.getBytes());
    }

    private String createSignature(IMethod m, Set<String> overloadedMethods) {
        String elementName = m.getElementName();
        StringBuilder result = new StringBuilder(elementName);
        if (overloadedMethods.contains(elementName)) {
            String[] stringArray = m.getParameterTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                result.append(this.sanitizeSignature(Signature.toString((String)type)));
                ++n2;
            }
        }
        result.append("()");
        return result.toString();
    }

    private String sanitizeSignature(String string) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private InputStream createXmlContentStream() {
        String cls = this.m_page.getClassName();
        String pkg = this.m_page.getPackageName();
        String className = StringUtils.isEmptyString(pkg) ? cls : String.valueOf(pkg) + "." + cls;
        return new ByteArrayInputStream(SuiteGenerator.createSingleClassSuite(className).getBytes());
    }

    private String toMethod(String a) {
        return String.valueOf(Character.toLowerCase(a.charAt(0))) + a.substring(1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

