/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util.signature;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.testng.eclipse.util.signature.IMethodDescriptor;

public class MethodDescriptor
implements IMethodDescriptor {
    private IMethod m_method;

    public MethodDescriptor(IMethod method) {
        this.m_method = method;
    }

    public String getName() {
        return this.m_method.getElementName();
    }

    public String getReturnTypeSignature() {
        try {
            return this.m_method.getReturnType();
        }
        catch (JavaModelException javaModelException) {
            return "";
        }
    }

    public String getSignature() {
        try {
            return this.m_method.getSignature();
        }
        catch (JavaModelException javaModelException) {
            return "";
        }
    }

    public String getFullSignature() {
        return String.valueOf(this.getName()) + this.getSignature();
    }

    public int getParameterCount() {
        return this.m_method.getNumberOfParameters();
    }

    public String getAnnotationType() {
        return "";
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.getFullSignature().hashCode();
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof IMethodDescriptor)) {
            return false;
        }
        IMethodDescriptor castedObj = (IMethodDescriptor)o;
        return this.getFullSignature().equals(castedObj.getFullSignature());
    }
}

