/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.util.DependencyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTUtil {
    public static final String PROJECT_TYPE = "P";
    public static final String DIRECTORY_TYPE = "D";
    public static final String CLASS_TYPE = "C";
    public static final String SOURCE_TYPE = "J";
    public static final String SUITE_TYPE = "S";
    public static final int NO_CTX = 0;
    public static final int TEST_CLASS_CTX = 1;
    public static final int TEST_SUITE_CTX = 2;

    private JDTUtil() {
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)JDTUtil.getWorkspaceRoot());
    }

    public static IJavaProject getJavaProject(String projectName) {
        if (projectName == null || projectName.length() < 1) {
            return null;
        }
        return JDTUtil.getJavaModel().getJavaProject(projectName);
    }

    public static IJavaProject[] getJavaProjects() {
        IJavaProject[] projects = null;
        try {
            projects = JavaCore.create((IWorkspaceRoot)JDTUtil.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            projects = new IJavaProject[]{};
        }
        return projects;
    }

    public static IJavaProject getJavaProjectContext() {
        IStructuredSelection ss;
        ISelection selection;
        IWorkbenchPage page = JDTUtil.getActivePage();
        if (page != null && (selection = page.getSelection()) != null && selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            Object obj = ss.getFirstElement();
            if (obj instanceof IJavaElement) {
                return ((IJavaElement)obj).getJavaProject();
            }
            if (obj instanceof IResource) {
                IProject pro = ((IResource)obj).getProject();
                IJavaProject ijp = JavaCore.create((IProject)pro);
                return ijp;
            }
        }
        return null;
    }

    public static String getResourceType(IResource resource) {
        if (resource instanceof IProject) {
            return PROJECT_TYPE;
        }
        if (resource instanceof IFolder) {
            return DIRECTORY_TYPE;
        }
        IFile file = (IFile)resource;
        if ("class".equals(file.getFileExtension())) {
            return CLASS_TYPE;
        }
        if ("java".equals(file.getFileExtension())) {
            return SOURCE_TYPE;
        }
        if ("xml".equals(file.getFileExtension())) {
            return SUITE_TYPE;
        }
        return "";
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = TestNGPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static int getResourceContextType() {
        IStructuredSelection ss;
        ISelection selection;
        IWorkbenchPage page = JDTUtil.getActivePage();
        if (page != null && (selection = page.getSelection()) != null && selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            Object obj = ss.getFirstElement();
            if (obj instanceof IJavaElement) {
                IJavaElement ije = (IJavaElement)obj;
                JDTUtil.ppp("getResourceContextType():IJavaElement: " + ije.getElementName());
                JDTUtil.ppp("getResourceContextType():Element type: " + ije.getElementType());
                if (5 <= ije.getElementType()) {
                    return 1;
                }
                return 0;
            }
            if (obj instanceof IResource) {
                IResource ir = (IResource)obj;
                if (1 == ir.getType()) {
                    if ("class".equals(ir.getFileExtension())) {
                        return 1;
                    }
                    if ("xml".equals(ir.getFileExtension())) {
                        return 2;
                    }
                    return 0;
                }
                return 0;
            }
        }
        return 0;
    }

    public static ICompilationUnit getJavaElement(IFile file) {
        IJavaElement ije = JavaCore.create((IFile)file);
        return (ICompilationUnit)ije.getAncestor(5);
    }

    public static Object getResourceContext() {
        IStructuredSelection ss;
        ISelection selection;
        IWorkbenchPage page = JDTUtil.getActivePage();
        if (page != null && (selection = page.getSelection()) != null && selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            IResource ir;
            Object obj = ss.getFirstElement();
            if (obj instanceof IJavaElement) {
                IJavaElement ije = (IJavaElement)obj;
                JDTUtil.ppp("IJavaElement: " + ije.getElementName());
                JDTUtil.ppp("Element type: " + ije.getElementType());
                if (5 <= ije.getElementType()) {
                    return ije.getAncestor(5);
                }
            }
            if (obj instanceof IResource && 1 == (ir = (IResource)obj).getType()) {
                if ("class".equals(ir.getFileExtension())) {
                    IJavaElement ije = JavaCore.create((IFile)((IFile)ir));
                    return ije.getAncestor(5);
                }
                if ("xml".equals(ir.getFileExtension())) {
                    return ir;
                }
            }
        }
        return null;
    }

    private static void ppp(Object msg) {
        System.out.println("[JDTUtil]: " + msg);
    }

    public static List<File> getSourceDirFileList(IJavaProject jproject) {
        if (jproject == null || !jproject.exists()) {
            return Collections.emptyList();
        }
        ArrayList sourcePaths = Lists.newArrayList();
        try {
            IPackageFragmentRoot[] sourceRoots = jproject.getAllPackageFragmentRoots();
            int i = 0;
            while (i < sourceRoots.length) {
                IResource sourceRes;
                if (1 == sourceRoots[i].getKind() && (sourceRes = sourceRoots[i].getCorrespondingResource()) != null) {
                    sourcePaths.add(sourceRes.getLocation().toFile());
                }
                ++i;
            }
        }
        catch (JavaModelException jme) {
            TestNGPlugin.log(jme);
        }
        return sourcePaths;
    }

    public static IJavaElement findElement(IJavaProject javaProject, String className, String methodName, String[] paramTypes) throws JavaModelException {
        IType type = javaProject.findType(className);
        if (type == null) {
            return null;
        }
        if (methodName == null) {
            return type;
        }
        if (paramTypes == null) {
            paramTypes = new String[]{};
        }
        ArrayList<String> params = new ArrayList<String>(paramTypes.length);
        int i = 0;
        while (i < paramTypes.length) {
            int idx = paramTypes[i].lastIndexOf(46);
            String typeName = idx == -1 ? paramTypes[i] : paramTypes[i].substring(idx + 1);
            params.add(Signature.createTypeSignature((String)typeName, (boolean)false));
            ++i;
        }
        IMethod method = JDTUtil.findMethodInTypeHierarchy(type, methodName, params.toArray(new String[paramTypes.length]));
        if (method == null) {
            method = JDTUtil.fuzzyFindMethodInTypeHierarchy(type, methodName, paramTypes);
        }
        return method;
    }

    public static IJavaElement findElement(IJavaProject javaProject, RunInfo runInfo) throws JavaModelException {
        return JDTUtil.findElement(javaProject, runInfo.getClassName(), runInfo.getMethodName(), runInfo.getParameterTypes());
    }

    public static IJavaElement findElement(IJavaProject javaProject, String className) throws JavaModelException {
        return javaProject.findType(className);
    }

    private static IMethod findMethodInTypeHierarchy(IType type, String methodName, String[] paramTypes) throws JavaModelException {
        IMethod method = type.getMethod(methodName, paramTypes);
        if (method != null && method.exists()) {
            return method;
        }
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
        IType[] types = typeHierarchy.getAllSuperclasses(type);
        int i = 0;
        while (i < types.length) {
            method = types[i].getMethod(methodName, paramTypes);
            if (method != null && method.exists()) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static IMethod fuzzyFindMethodInTypeHierarchy(IType type, String methodName, String[] paramTypes) throws JavaModelException {
        ArrayList<IMethod> fuzzyResults = new ArrayList<IMethod>();
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i].getElementName()) && methods[i].exists()) {
                if (methods[i].getNumberOfParameters() == paramTypes.length) {
                    return methods[i];
                }
                fuzzyResults.add(methods[i]);
            }
            ++i;
        }
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
        IType[] types = typeHierarchy.getAllSuperclasses(type);
        int i2 = 0;
        while (i2 < types.length) {
            methods = types[i2].getMethods();
            int j = 0;
            while (j < methods.length) {
                if (methodName.equals(methods[j].getElementName()) && methods[j].exists()) {
                    return methods[j];
                }
                ++j;
            }
            ++i2;
        }
        return fuzzyResults.isEmpty() ? null : (IMethod)fuzzyResults.get(0);
    }

    public static List<MethodDefinition> solveDependencies(IMethod method) {
        HashSet parsedMethods = Sets.newHashSet();
        MethodDefinition md = new MethodDefinition(method);
        parsedMethods.add(method.getElementName());
        ArrayList results = Lists.newArrayList();
        results.add(md);
        results.addAll(JDTUtil.solveDependencies(md, parsedMethods));
        return results;
    }

    private static List<MethodDefinition> solveDependencies(MethodDefinition methodDef, Set<String> parsedMethods) {
        DependencyVisitor dv = JDTUtil.parse(methodDef.getMethod());
        ArrayList results = Lists.newArrayList();
        List<String> dependsOnMethods = dv.getDependsOnMethods();
        if (!dependsOnMethods.isEmpty()) {
            int i = 0;
            while (i < dependsOnMethods.size()) {
                IMethod meth;
                String methodName = dependsOnMethods.get(i);
                if (!parsedMethods.contains(methodName) && (meth = JDTUtil.solveMethod(methodDef.getMethod().getDeclaringType(), methodName)) != null) {
                    MethodDefinition md = new MethodDefinition(meth);
                    parsedMethods.add(meth.getElementName());
                    results.add(md);
                    methodDef.addDependencyMethod(md);
                    results.addAll(JDTUtil.solveDependencies(md, parsedMethods));
                }
                ++i;
            }
        }
        methodDef.addDependencyGroups(dv.getDependsOnGroups());
        return results;
    }

    private static DependencyVisitor parse(IMethod method) {
        DependencyVisitor dv = new DependencyVisitor();
        try {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(method.getSource().toCharArray());
            parser.setKind(4);
            ASTNode node = parser.createAST(null);
            node.accept((ASTVisitor)dv);
        }
        catch (JavaModelException javaModelException) {}
        return dv;
    }

    private static IMethod solveMethod(IType type, String methodName) {
        try {
            IMethod[] typemethods = type.getMethods();
            int i = 0;
            while (i < typemethods.length) {
                if (methodName.equals(typemethods[i].getElementName())) {
                    return typemethods[i];
                }
                ++i;
            }
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            IType[] superTypes = typeHierarchy.getAllSuperclasses(type);
            int i2 = 0;
            while (i2 < superTypes.length) {
                IMethod[] methods = superTypes[i2].getMethods();
                int j = 0;
                while (j < methods.length) {
                    if (methodName.equals(methods[j].getElementName())) {
                        return methods[j];
                    }
                    ++j;
                }
                ++i2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static class MethodDefinition {
        private final IMethod m_method;
        private final Set m_dependsongroups = new HashSet();
        private final Set<MethodDefinition> m_dependsonmethods = new HashSet<MethodDefinition>();

        public MethodDefinition(IMethod method) {
            this.m_method = method;
        }

        public void addDependencyGroups(List dependsOnGroups) {
            if (dependsOnGroups != null && !dependsOnGroups.isEmpty()) {
                this.m_dependsongroups.addAll(dependsOnGroups);
            }
        }

        public void addDependencyMethod(MethodDefinition md) {
            this.m_dependsonmethods.add(md);
        }

        public IMethod getMethod() {
            return this.m_method;
        }

        public String getKey() {
            return this.m_method.getKey();
        }

        public Set getGroups() {
            return this.m_dependsongroups;
        }
    }
}

