/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.conversion;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;
import org.testng.eclipse.ui.Images;

public class JUnitRewriteCorrectionProposal
implements IJavaCompletionProposal {
    private ASTRewrite m_rewriter;
    private ICompilationUnit m_cu;
    private String m_name;
    private final int m_surroundLines = 1;

    public JUnitRewriteCorrectionProposal(String name, ICompilationUnit cu, ASTRewrite rewriter, int i) {
        this.m_name = name;
        this.m_rewriter = rewriter;
        this.m_cu = cu;
    }

    public void apply(IDocument document) {
        TextEdit edits = this.m_rewriter.rewriteAST(document, null);
        try {
            edits.apply(document);
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.getHtml();
    }

    protected TextChange createTextChange() throws CoreException {
        ICompilationUnit cu = this.m_cu;
        String name = "TestNG";
        DocumentChange change = null;
        Document document = new Document(cu.getSource());
        document.setInitialLineDelimiter(StubUtility.getLineDelimiterUsed((IJavaElement)cu));
        change = new DocumentChange(name, (IDocument)document);
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        this.addEdits(change.getCurrentDocument((IProgressMonitor)new NullProgressMonitor()), (TextEdit)rootEdit);
        return change;
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
        ASTRewrite rewrite = this.m_rewriter;
        if (rewrite != null) {
            try {
                TextEdit edit = rewrite.rewriteAST();
                editRoot.addChild(edit);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(JavaUIStatus.createError((int)4, (Throwable)e));
            }
        }
    }

    private TextChange getTextChange() {
        try {
            return this.createTextChange();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getHtml() {
        StringBuffer buf = new StringBuffer();
        try {
            TextChange change = this.getTextChange();
            change.setKeepPreviewEdits(true);
            IDocument previewContent = change.getPreviewDocument((IProgressMonitor)new NullProgressMonitor());
            TextEdit rootEdit = change.getPreviewEdit(change.getEdit());
            class EditAnnotator
            extends TextEditVisitor {
                private int m_writtenToPos = 0;
                private final /* synthetic */ IDocument val$previewContent;
                private final /* synthetic */ StringBuffer val$buf;

                EditAnnotator(IDocument iDocument, StringBuffer stringBuffer) {
                    this.val$previewContent = iDocument;
                    this.val$buf = stringBuffer;
                }

                public void unchangedUntil(int pos) {
                    if (pos > this.m_writtenToPos) {
                        JUnitRewriteCorrectionProposal.this.appendContent(this.val$previewContent, this.m_writtenToPos, pos, this.val$buf, true);
                        this.m_writtenToPos = pos;
                    }
                }

                public boolean visit(MoveTargetEdit edit) {
                    return true;
                }

                public boolean visit(CopyTargetEdit edit) {
                    return true;
                }

                public boolean visit(InsertEdit edit) {
                    return this.rangeAdded((TextEdit)edit);
                }

                public boolean visit(ReplaceEdit edit) {
                    if (edit.getLength() > 0) {
                        return this.rangeAdded((TextEdit)edit);
                    }
                    return this.rangeRemoved((TextEdit)edit);
                }

                public boolean visit(MoveSourceEdit edit) {
                    return this.rangeRemoved((TextEdit)edit);
                }

                public boolean visit(DeleteEdit edit) {
                    return this.rangeRemoved((TextEdit)edit);
                }

                private boolean rangeRemoved(TextEdit edit) {
                    this.unchangedUntil(edit.getOffset());
                    return false;
                }

                private boolean rangeAdded(TextEdit edit) {
                    this.unchangedUntil(edit.getOffset());
                    this.val$buf.append("<b>");
                    JUnitRewriteCorrectionProposal.this.appendContent(this.val$previewContent, edit.getOffset(), edit.getExclusiveEnd(), this.val$buf, false);
                    this.val$buf.append("</b>");
                    this.m_writtenToPos = edit.getExclusiveEnd();
                    return false;
                }
            }
            EditAnnotator ea = new EditAnnotator(previewContent, buf);
            rootEdit.accept((TextEditVisitor)ea);
            ea.unchangedUntil(previewContent.getLength());
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
        return buf.toString();
    }

    private void appendContent(IDocument text, int startOffset, int endOffset, StringBuffer buf, boolean surroundLinesOnly) {
        try {
            int startLine = text.getLineOfOffset(startOffset);
            int endLine = text.getLineOfOffset(endOffset);
            boolean dotsAdded = false;
            if (surroundLinesOnly && startOffset == 0) {
                startLine = Math.max(endLine - 1, 0);
                buf.append("...<br>");
                dotsAdded = true;
            }
            int i = startLine;
            while (i <= endLine) {
                if (surroundLinesOnly && i - startLine > 1 && endLine - i > 1) {
                    if (!dotsAdded) {
                        buf.append("...<br>");
                        dotsAdded = true;
                    } else if (endOffset == text.getLength()) {
                        return;
                    }
                } else {
                    IRegion lineInfo = text.getLineInformation(i);
                    int start = lineInfo.getOffset();
                    int end = start + lineInfo.getLength();
                    int from = Math.max(start, startOffset);
                    int to = Math.min(end, endOffset);
                    String content = text.get(from, to - from);
                    if (!surroundLinesOnly || from != start || !JUnitRewriteCorrectionProposal.containsOnlyWhitespaces(content)) {
                        int k = 0;
                        while (k < content.length()) {
                            char ch = content.charAt(k);
                            if (ch == '<') {
                                buf.append("&lt;");
                            } else if (ch == '>') {
                                buf.append("&gt;");
                            } else {
                                buf.append(ch);
                            }
                            ++k;
                        }
                        if (to == end && to != endOffset) {
                            buf.append("<br>");
                        }
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private static boolean containsOnlyWhitespaces(String s) {
        int size = s.length();
        int i = 0;
        while (i < size) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getDisplayString() {
        return this.m_name;
    }

    public Image getImage() {
        return Images.getTestNGImage();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 0;
    }
}

