/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.testng.remote.strprotocol.IRemoteSuiteListener;
import org.testng.remote.strprotocol.IRemoteTestListener;
import org.testng.xml.ResultXMLParser;

public class WatchResultThread {
    private static final boolean DEBUG = false;
    private Runnable m_watchResultRunnable;
    private boolean m_watchResults = true;
    private Thread m_watchResultThread;

    public WatchResultThread(final String path, final IRemoteSuiteListener suiteListener, final IRemoteTestListener testListener) {
        this.m_watchResultRunnable = new Runnable(){

            public void run() {
                File f = new File(path, "testng-results.xml");
                long timeStamp = f.lastModified();
                WatchResultThread.p("Watching " + path);
                while (WatchResultThread.this.m_watchResults) {
                    long t = f.lastModified();
                    WatchResultThread.p("Comparing " + t + " and " + timeStamp + " for " + f);
                    if (t != timeStamp) {
                        WatchResultThread.p("The file changed, updating the view");
                        timeStamp = t;
                        ResultXMLParser parser = new ResultXMLParser(suiteListener, testListener);
                        try {
                            parser.parse(path, (InputStream)new FileInputStream(f), false);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                WatchResultThread.p("No longer watching " + path);
            }
        };
        this.m_watchResultThread = new Thread(this.m_watchResultRunnable);
        this.m_watchResultThread.start();
    }

    private static void p(String string) {
    }

    public void stopWatching() {
        this.m_watchResults = false;
    }
}

