/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.testng.eclipse.ui.OpenEditorAction;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.TestRunnerViewPart;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.ResourceUtil;

public class OpenTestAction
extends OpenEditorAction {
    private String fMethodName;
    private ISourceRange fRange;
    private RunInfo fRunInfo;

    public OpenTestAction(TestRunnerViewPart testRunner, RunInfo runInfo) {
        this(testRunner, runInfo.getClassName(), runInfo.getMethodName(), true);
        this.fRunInfo = runInfo;
    }

    public OpenTestAction(TestRunnerViewPart testRunner, RunInfo runInfo, boolean activate) {
        this(testRunner, runInfo.getClassName(), runInfo.getMethodName(), activate);
        this.fRunInfo = runInfo;
    }

    public OpenTestAction(TestRunnerViewPart testRunner, String className) {
        this(testRunner, className, null, true);
    }

    public OpenTestAction(TestRunnerViewPart testRunner, String className, String method, boolean activate) {
        super(testRunner, className, activate);
        this.fMethodName = method;
    }

    protected IJavaElement findElement(IJavaProject project, String className) throws JavaModelException {
        IJavaElement javaElement = null;
        javaElement = this.fRunInfo != null ? JDTUtil.findElement(project, this.fRunInfo) : JDTUtil.findElement(project, className, this.fMethodName, null);
        if (this.fMethodName == null) {
            return javaElement;
        }
        IMethod method = (IMethod)javaElement;
        if (method == null) {
            String title = ResourceUtil.getString("OpenTestAction.error.title");
            String message = ResourceUtil.getFormattedString("OpenTestAction.error.methodNoFound", this.fMethodName);
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return JDTUtil.findElement(project, className);
        }
        this.fRange = method.getNameRange();
        return javaElement;
    }

    protected void reveal(ITextEditor textEditor) {
        if (this.fRange != null) {
            textEditor.selectAndReveal(this.fRange.getOffset(), this.fRange.getLength());
        }
    }

    public boolean isEnabled() {
        if (this.getClassName() == null) {
            return false;
        }
        try {
            IJavaProject project = this.getLaunchedProject();
            if (project != null) {
                return project.findType(this.getClassName()) != null;
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

