/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.testng.eclipse.ui.FailureTrace;

public abstract class AbstractTraceAction
extends SelectionListenerAction {
    private FailureTrace fView;
    private final Clipboard fClipboard;
    private TestElement fTestElement;

    public AbstractTraceAction(FailureTrace view, Clipboard clipboard, String title) {
        super(title);
        Assert.isNotNull((Object)clipboard);
        this.fView = view;
        this.fClipboard = clipboard;
    }

    public void transfer(String copyMe) {
        block3: {
            String trace = copyMe;
            String source = trace == null && this.fTestElement != null ? this.fTestElement.getTestName() : this.convertLineTerminators(trace);
            if (source == null || source.length() == 0) {
                return;
            }
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{this.convertLineTerminators(source)}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code == 2002) break block3;
                throw e;
            }
        }
    }

    public void handleTestSelected(TestElement test) {
        this.fTestElement = test;
    }

    public FailureTrace getFView() {
        return this.fView;
    }

    private String convertLineTerminators(String in) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(in);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                printWriter.println(line);
            }
        }
        catch (IOException iOException) {
            return in;
        }
        return stringWriter.toString();
    }
}

