/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.refactoring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.testng.eclipse.refactoring.ImportAssertRewriter;
import org.testng.eclipse.refactoring.PullTestRewriter;
import org.testng.eclipse.refactoring.PushTestRewriter;
import org.testng.eclipse.refactoring.TestNGVisitor;
import org.testng.eclipse.ui.conversion.BaseQuickAssistProcessor;
import org.testng.eclipse.ui.conversion.IRewriteProvider;
import org.testng.eclipse.ui.conversion.JUnitRewriteCorrectionProposal;

public class TestNGQuickAssistProcessor
extends BaseQuickAssistProcessor
implements IQuickAssistProcessor {
    private TestNGVisitor m_visitor;
    private CompilationUnit m_astRoot;
    private AST m_ast;
    private ICompilationUnit m_compilationUnit;

    public boolean hasAssists(IInvocationContext context) throws CoreException {
        this.init(context);
        return TestNGQuickAssistProcessor.hasPushAssists(this.m_visitor) || TestNGQuickAssistProcessor.hasPullAssists(this.m_visitor) || TestNGQuickAssistProcessor.hasAssertImportAssists(this.m_visitor);
    }

    private static boolean hasAssertImportAssists(TestNGVisitor visitor) {
        return visitor.getAsserts().size() > 0;
    }

    private void init(IInvocationContext context) {
        this.m_compilationUnit = context.getCompilationUnit();
        this.m_astRoot = TestNGQuickAssistProcessor.createCompilationUnit(this.m_compilationUnit);
        this.m_ast = context.getASTRoot().getAST();
        this.m_visitor = new TestNGVisitor();
        this.m_astRoot.accept((ASTVisitor)this.m_visitor);
    }

    private static boolean hasPushAssists(TestNGVisitor visitor) {
        return visitor.getTestClassAnnotation() != null;
    }

    private static boolean hasPullAssists(TestNGVisitor visitor) {
        Annotation testClass = visitor.getTestClassAnnotation();
        return visitor.getTestMethods().size() > 0 && testClass == null;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList vResult = Lists.newArrayList();
        this.init(context);
        if (this.hasAssists(context)) {
            String node;
            ArrayList providers = Lists.newArrayList();
            if (TestNGQuickAssistProcessor.hasPushAssists(this.m_visitor)) {
                providers.add(new PushTestRewriter());
            }
            if (TestNGQuickAssistProcessor.hasPullAssists(this.m_visitor)) {
                providers.add(new PullTestRewriter());
            }
            if (TestNGQuickAssistProcessor.hasAssertImportAssists(this.m_visitor) && (node = this.findAssertInContext(context)) != null) {
                providers.add(new ImportAssertRewriter(node));
            }
            for (IRewriteProvider provider : providers) {
                ASTRewrite rewriter = provider.createRewriter(this.m_astRoot, this.m_ast);
                vResult.add(new JUnitRewriteCorrectionProposal(provider.getName(), this.m_compilationUnit, rewriter, 1));
            }
        }
        return vResult.toArray(new IJavaCompletionProposal[vResult.size()]);
    }

    private String findAssertInContext(IInvocationContext context) {
        ASTNode node = context.getCoveringNode();
        while (node != null) {
            if (node instanceof MethodInvocation) {
                String nodeName = ((MethodInvocation)node).getName().toString();
                if (this.m_visitor.getAsserts().contains(nodeName)) {
                    return nodeName;
                }
            }
            node = node.getParent();
        }
        return null;
    }
}

