/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch.components;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.testng.eclipse.launch.components.ITestContent;
import org.testng.eclipse.ui.util.TypeParser;

public class Filters {
    public static final ViewerFilter TEST_FILTER = new TestViewerFilter();
    public static final ViewerFilter SOURCE_DIRECTORY_FILTER = new SourceDirectoryFilter();
    public static ITypeFilter SINGLE_TEST = new ITypeFilter(){

        public boolean accept(IType type) {
            boolean result = TypeParser.parseType(type).isTestNGClass();
            return result;
        }
    };
    public static ITypeFilter SUITE = new ITypeFilter(){

        public boolean accept(IType type) {
            boolean result = false;
            Filters.ppp("CHECKING TESTNG.XML FOR " + type);
            return result;
        }
    };

    private Filters() {
    }

    public static final ViewerFilter createProjectContentFilter(IJavaProject ijp) {
        IProject[] allProjects = JavaPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject iproject = ijp.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)iproject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        return new ProjectContentFilter(rejectedElements);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasTests(IContainer folder) {
        try {
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IFile && Filters.isTest((IFile)children[i])) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < children.length) {
                if (children[i] instanceof IFolder && Filters.hasTests((IContainer)children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (CoreException coreException) {}
        return false;
    }

    private static boolean isTest(IFile file) {
        return "class".equals(file.getFileExtension()) || Filters.isSource(file) || "xml".equals(file.getFileExtension());
    }

    private static boolean isSource(IFile file) {
        return "java".equals(file.getFileExtension());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasSources(IContainer folder) {
        try {
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IFile && Filters.isSource((IFile)children[i])) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < children.length) {
                if (children[i] instanceof IFolder && Filters.hasSources((IContainer)children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static void ppp(String s) {
        System.out.println("[Filters] " + s);
    }

    public static class GroupFilter
    implements ITypeFilter {
        private String[] m_groupNames;

        public GroupFilter(String ... groupNames) {
            this.m_groupNames = groupNames;
        }

        public boolean accept(IType type) {
            ITestContent parsedType = TypeParser.parseType(type);
            if (!parsedType.isTestNGClass()) {
                return false;
            }
            String[] stringArray = this.m_groupNames;
            int n = this.m_groupNames.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                if (parsedType.getGroups().contains(group)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static interface ITypeFilter {
        public boolean accept(IType var1);
    }

    private static class ProjectContentFilter
    extends ViewerFilter {
        private List m_rejectedEntries;

        private ProjectContentFilter(List rejectedEntries) {
            this.m_rejectedEntries = rejectedEntries;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.m_rejectedEntries == null || this.m_rejectedEntries.size() == 0) {
                return true;
            }
            int i = 0;
            while (i < this.m_rejectedEntries.size()) {
                if (element.equals(this.m_rejectedEntries.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class SourceDirectoryFilter
    extends ViewerFilter {
        private SourceDirectoryFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IProject) {
                return true;
            }
            if (element instanceof IFolder) {
                return Filters.hasSources((IContainer)element);
            }
            return false;
        }
    }

    private static class TestViewerFilter
    extends ViewerFilter {
        private TestViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IProject) {
                return true;
            }
            if (element instanceof IFolder) {
                return Filters.hasTests((IContainer)element);
            }
            return element instanceof IFile && Filters.isTest((IFile)element);
        }
    }
}

