/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.launch.TestNGMainTab;
import org.testng.eclipse.ui.util.Utils;

public abstract class TestngTestSelector {
    private Button m_radioButton;
    private Text m_text;
    private ModifyListener m_textAdapter;
    private TestNGMainTab m_callback;
    private TestNGLaunchConfigurationConstants.LaunchType m_launchType;

    public abstract void initializeFrom(ILaunchConfiguration var1);

    TestngTestSelector() {
    }

    TestngTestSelector(TestNGMainTab callback, ButtonHandler buttonHandler, TestNGLaunchConfigurationConstants.LaunchType testngType, Composite comp, String labelKey) {
        this.init(callback, buttonHandler, comp, testngType, labelKey);
    }

    public void attachModificationListener() {
        this.m_text.addModifyListener(this.m_textAdapter);
    }

    public void detachModificationListener() {
        this.m_text.removeModifyListener(this.m_textAdapter);
    }

    public void enableRadio(boolean state) {
        this.m_radioButton.setEnabled(state);
    }

    public void setTextEditable(boolean editable) {
        this.m_text.setEditable(editable);
    }

    public void setRadioSelected(boolean selected) {
        this.m_radioButton.setSelection(selected);
    }

    public void setText(String string) {
        this.m_text.setText(string);
    }

    public String getText() {
        return this.m_text.getText();
    }

    public TestNGLaunchConfigurationConstants.LaunchType getTestngType() {
        return this.m_launchType;
    }

    public Button getRadioButton() {
        return this.m_radioButton;
    }

    public TestNGMainTab getCallback() {
        return this.m_callback;
    }

    final void init(TestNGMainTab callback, ButtonHandler buttonHandler, Composite comp, TestNGLaunchConfigurationConstants.LaunchType testngType, String labelKey) {
        this.m_callback = callback;
        this.m_launchType = testngType;
        this.m_textAdapter = new TextAdapter(testngType);
        RadioAdapter radioAdapter = new RadioAdapter(testngType);
        ButtonAdapter buttonAdapter = new ButtonAdapter(testngType, buttonHandler);
        Utils.Widgets wt = Utils.createWidgetTriple(comp, labelKey, (SelectionListener)radioAdapter, (SelectionListener)buttonAdapter, this.m_textAdapter);
        this.m_radioButton = wt.radio;
        this.m_text = wt.text;
    }

    class ButtonAdapter
    extends SelectionAdapter {
        private TestNGLaunchConfigurationConstants.LaunchType m_type;
        private ButtonHandler m_handler;

        public ButtonAdapter(TestNGLaunchConfigurationConstants.LaunchType type, ButtonHandler handler) {
            this.m_type = type;
            this.m_handler = handler;
        }

        public void widgetSelected(SelectionEvent evt) {
            TestngTestSelector.this.m_callback.setType(this.m_type);
            try {
                TestngTestSelector.this.m_callback.setEnabledRadios(false);
                this.m_handler.handleButton();
            }
            finally {
                TestngTestSelector.this.m_callback.setEnabledRadios(true);
            }
        }
    }

    public static interface ButtonHandler {
        public void handleButton();
    }

    class RadioAdapter
    extends SelectionAdapter {
        private TestNGLaunchConfigurationConstants.LaunchType m_type;

        public RadioAdapter(TestNGLaunchConfigurationConstants.LaunchType type) {
            this.m_type = type;
        }

        public void widgetSelected(SelectionEvent evt) {
            if (((Button)evt.widget).getSelection()) {
                TestngTestSelector.this.m_callback.setType(this.m_type);
            }
        }
    }

    class TextAdapter
    implements ModifyListener {
        TestNGLaunchConfigurationConstants.LaunchType m_type;

        public TextAdapter(TestNGLaunchConfigurationConstants.LaunchType type) {
            this.m_type = type;
        }

        public void modifyText(ModifyEvent evt) {
            TestngTestSelector.this.m_callback.setType(this.m_type);
        }
    }
}

