/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.launch.GroupSelector;
import org.testng.eclipse.launch.SuiteSelector2;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.launch.TestngTestSelector;
import org.testng.eclipse.launch.components.Filters;
import org.testng.eclipse.ui.Images;
import org.testng.eclipse.ui.util.ConfigurationHelper;
import org.testng.eclipse.ui.util.ProjectChooserDialog;
import org.testng.eclipse.ui.util.TestSelectionDialog;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.SWTUtil;
import org.testng.eclipse.util.StringUtils;
import org.testng.eclipse.util.TestSearchEngine;

public class TestNGMainTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab {
    private static ImageRegistry m_imageRegistry = null;
    private static final String UNKNOWN_CONSTANT = "Unknown TestNGLaunchConfigurationConstants: ";
    private Text m_projectText;
    private IJavaProject m_selectedProject;
    private TestngTestSelector m_classSelector;
    private TestngTestSelector m_methodSelector;
    private GroupSelector m_groupSelector;
    private TestngTestSelector m_suiteSelector;
    private TestngTestSelector m_packageSelector;
    private TestNGLaunchConfigurationConstants.LaunchType m_typeOfTestRun = TestNGLaunchConfigurationConstants.LaunchType.UNDEFINED;
    private Combo m_logLevelCombo;
    private List<TestngTestSelector> m_launchSelectors = Lists.newArrayList();
    private Map<String, List<String>> m_classMethods;

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)layout);
        this.setControl((Control)comp);
        this.createProjectSelectionGroup(comp);
        Group group = this.createGroup(comp, "TestNGMainTab.label.run");
        this.createSelectors((Composite)group);
        this.createRuntimeGroup(comp);
    }

    private void createSelectors(Composite comp) {
        TestngTestSelector.ButtonHandler handler = new TestngTestSelector.ButtonHandler(){

            public void handleButton() {
                TestNGMainTab.this.handleSearchButtonSelected(TestNGLaunchConfigurationConstants.LaunchType.CLASS);
            }
        };
        this.m_classSelector = new TestngTestSelector(this, handler, TestNGLaunchConfigurationConstants.LaunchType.CLASS, comp, "TestNGMainTab.label.test"){

            public void initializeFrom(ILaunchConfiguration configuration) {
                List<String> testClassNames = ConfigurationHelper.getClasses(configuration);
                this.setText(StringUtils.listToString(testClassNames));
            }
        };
        this.m_launchSelectors.add(this.m_classSelector);
        handler = new TestngTestSelector.ButtonHandler(){

            public void handleButton() {
                TestNGMainTab.this.handleSearchButtonSelected(TestNGLaunchConfigurationConstants.LaunchType.METHOD);
            }
        };
        this.m_methodSelector = new TestngTestSelector(this, handler, TestNGLaunchConfigurationConstants.LaunchType.METHOD, comp, "TestNGMainTab.label.method"){

            public void initializeFrom(ILaunchConfiguration configuration) {
                List<String> names = ConfigurationHelper.getMethods(configuration);
                this.setText(StringUtils.listToString(names));
            }
        };
        this.m_launchSelectors.add(this.m_methodSelector);
        this.m_groupSelector = new GroupSelector(this, comp);
        this.m_launchSelectors.add(this.m_groupSelector);
        handler = new TestngTestSelector.ButtonHandler(){

            public void handleButton() {
                TestNGMainTab.this.handleSearchButtonSelected(TestNGLaunchConfigurationConstants.LaunchType.PACKAGE);
            }
        };
        this.m_packageSelector = new TestngTestSelector(this, handler, TestNGLaunchConfigurationConstants.LaunchType.PACKAGE, comp, "TestNGMainTab.label.package"){

            public void initializeFrom(ILaunchConfiguration configuration) {
                List<String> names = ConfigurationHelper.getPackages(configuration);
                this.setText(StringUtils.listToString(names));
            }
        };
        this.m_launchSelectors.add(this.m_packageSelector);
        this.m_suiteSelector = new SuiteSelector2(this, comp);
        this.m_launchSelectors.add(this.m_suiteSelector);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        if (this.m_selectedProject == null) {
            this.m_selectedProject = JDTUtil.getJavaProjectContext();
        }
        ConfigurationHelper.createBasicConfiguration(this.m_selectedProject, config);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateProjectFromConfig(configuration);
        this.dettachModificationListeners();
        for (TestngTestSelector sel : this.m_launchSelectors) {
            sel.initializeFrom(configuration);
        }
        int logLevel = ConfigurationHelper.getLogLevel(configuration);
        this.m_logLevelCombo.select(logLevel);
        TestNGLaunchConfigurationConstants.LaunchType type = ConfigurationHelper.getType(configuration);
        this.setType(type);
        this.m_classMethods = ConfigurationHelper.getClassMethods(configuration);
        this.attachModificationListeners();
    }

    private void dettachModificationListeners() {
        for (TestngTestSelector sel : this.m_launchSelectors) {
            sel.detachModificationListener();
        }
    }

    private void attachModificationListeners() {
        for (TestngTestSelector sel : this.m_launchSelectors) {
            sel.attachModificationListener();
        }
    }

    protected void updateProjectFromConfig(ILaunchConfiguration configuration) {
        String projectName = ConfigurationHelper.getProjectName(configuration);
        if (projectName != null) {
            this.m_selectedProject = JDTUtil.getJavaProject(projectName);
            this.m_projectText.setText(projectName);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        ConfigurationHelper.updateLaunchConfiguration(configuration, new ConfigurationHelper.LaunchInfo(this.m_projectText.getText(), this.m_typeOfTestRun, StringUtils.stringToList(this.m_classSelector.getText().trim()), StringUtils.stringToList(this.m_packageSelector.getText().trim()), this.m_classMethods, this.m_groupSelector.getValueMap(), this.m_suiteSelector.getText(), "JDK", this.m_logLevelCombo.getText()));
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean result = this.getErrorMessage() == null;
        return result;
    }

    public String getName() {
        return ResourceUtil.getString("TestNGMainTab.tab.label");
    }

    public Image getImage() {
        return Images.getTestNGImage();
    }

    public void validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.m_selectedProject == null) {
            this.setErrorMessage(ResourceUtil.getString("TestNGMainTab.error.projectnotdefined"));
            return;
        }
        if (!this.m_selectedProject.getProject().exists()) {
            this.setErrorMessage(ResourceUtil.getFormattedString("TestNGMainTab.error.projectnotexists", this.m_projectText.getText()));
            return;
        }
        if (!this.m_selectedProject.getProject().isOpen()) {
            this.setErrorMessage(ResourceUtil.getFormattedString("TestNGMainTab.error.projectnotopen", this.m_projectText.getText()));
            return;
        }
        if (this.getType() != TestNGLaunchConfigurationConstants.LaunchType.UNDEFINED) {
            switch (this.getType()) {
                case CLASS: {
                    if (this.m_classSelector.getText().trim().length() >= 1) break;
                    this.setErrorMessage(ResourceUtil.getString("TestNGMainTab.error.testclassnotdefined"));
                    break;
                }
                case SUITE: {
                    if (this.m_suiteSelector.getText().trim().length() >= 1) break;
                    this.setErrorMessage(ResourceUtil.getString("TestNGMainTab.error.suitenotdefined"));
                    break;
                }
                case METHOD: {
                    if (this.m_methodSelector.getText().trim().length() >= 1) break;
                    this.setErrorMessage(ResourceUtil.getString("TestNGMainTab.error.methodnotdefined"));
                    break;
                }
                case GROUP: {
                    if (this.m_groupSelector.getText().trim().length() >= 1) break;
                    this.setErrorMessage(ResourceUtil.getString("TestNGMainTab.error.groupnotdefined"));
                    break;
                }
                case PACKAGE: {
                    if (this.m_packageSelector.getText().trim().length() >= 1) break;
                    this.setErrorMessage(ResourceUtil.getString("TestNGMainTab.error.packagenotdefined"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(UNKNOWN_CONSTANT + (Object)((Object)this.getType()));
                }
            }
        }
    }

    void handleSearchButtonSelected(TestNGLaunchConfigurationConstants.LaunchType testngType) {
        Object[] types = new Object[]{};
        TestSelectionDialog dialog = null;
        IJavaProject selectedProject = this.getSelectedProject();
        if (selectedProject == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No project", (String)"Please select a project");
            return;
        }
        try {
            switch (testngType) {
                case CLASS: {
                    types = TestSearchEngine.findTests((IRunnableContext)this.getLaunchConfigurationDialog(), new Object[]{this.m_selectedProject}, Filters.SINGLE_TEST);
                    dialog = TestSelectionDialog.createTestTypeSelectionDialog(this.getShell(), this.m_selectedProject, types, Filters.SINGLE_TEST);
                    break;
                }
                case METHOD: {
                    types = TestSearchEngine.findMethods((IRunnableContext)this.getLaunchConfigurationDialog(), new Object[]{this.m_selectedProject}, this.m_classSelector.getText());
                    dialog = TestSelectionDialog.createMethodSelectionDialog(this.getShell(), this.m_selectedProject, types);
                    break;
                }
                case PACKAGE: {
                    types = TestSearchEngine.findPackages((IRunnableContext)this.getLaunchConfigurationDialog(), new Object[]{this.m_selectedProject});
                    dialog = TestSelectionDialog.createPackageSelectionDialog(this.getShell(), this.m_selectedProject, types);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(UNKNOWN_CONSTANT + (Object)((Object)testngType));
                }
            }
        }
        catch (InterruptedException e) {
            TestNGPlugin.log(e);
        }
        catch (InvocationTargetException e) {
            TestNGPlugin.log(e.getTargetException());
        }
        dialog.setBlockOnOpen(true);
        dialog.setTitle(ResourceUtil.getString("TestNGMainTab.testdialog.title"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        Object type = results[0];
        if (type != null) {
            switch (testngType) {
                case CLASS: {
                    this.m_classSelector.setText(((IType)type).getFullyQualifiedName().trim());
                    this.m_selectedProject = ((IType)type).getJavaProject();
                    break;
                }
                case METHOD: {
                    String fullName = (String)type;
                    int index = fullName.lastIndexOf(46);
                    String className = fullName.substring(0, index);
                    String methodName = fullName.substring(index + 1);
                    this.m_classSelector.setText(className);
                    this.m_methodSelector.setText(methodName);
                    this.m_classMethods = Maps.newHashMap();
                    ArrayList methods = Lists.newArrayList();
                    methods.add(methodName);
                    this.m_classMethods.put(className, methods);
                    break;
                }
                case SUITE: {
                    IFile file = (IFile)type;
                    this.m_suiteSelector.setText(file.getProjectRelativePath().toOSString().trim());
                    break;
                }
                case PACKAGE: {
                    this.m_packageSelector.setText((String)type);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(UNKNOWN_CONSTANT + (Object)((Object)testngType));
                }
            }
        }
        this.updateDialog();
    }

    private void handleProjectTextModified() {
        String projectName = this.m_projectText.getText().trim();
        this.m_selectedProject = JDTUtil.getJavaProject(projectName);
        this.updateDialog();
    }

    private void handleProjectButtonSelected() {
        IJavaProject project = ProjectChooserDialog.getSelectedProject(this.getShell());
        if (project == null) {
            return;
        }
        this.m_selectedProject = project;
        this.m_projectText.setText(project.getElementName());
        this.updateDialog();
    }

    private void createRuntimeGroup(Composite parent) {
        Group group = this.createGroup(parent, "TestNGMainTab.runtime.type");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Label label = new Label((Composite)group, 16384);
        label.setLayoutData((Object)gd);
        label.setText(ResourceUtil.getString("TestNGMainTab.testng.loglevel"));
        this.m_logLevelCombo = new Combo((Composite)group, 12);
        gd = new GridData(640);
        gd.widthHint = 70;
        this.m_logLevelCombo.setLayoutData((Object)gd);
        int i = 0;
        while (i < 11) {
            this.m_logLevelCombo.add("" + i);
            ++i;
        }
        this.m_logLevelCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TestNGMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createProjectSelectionGroup(Composite comp) {
        Group projectGroup = this.createGroup(comp, "TestNGMainTab.label.project");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.m_projectText = new Text((Composite)projectGroup, 2052);
        this.m_projectText.setLayoutData((Object)gd);
        this.m_projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestNGMainTab.this.handleProjectTextModified();
            }
        });
        Button projectSearchButton = new Button((Composite)projectGroup, 8);
        projectSearchButton.setText(ResourceUtil.getString("TestNGMainTab.label.browse"));
        projectSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TestNGMainTab.this.handleProjectButtonSelected();
            }
        });
        SWTUtil.setButtonGridData(projectSearchButton);
    }

    private Group createGroup(Composite parent, String groupTitleKey) {
        Group group = new Group(parent, 16);
        group.setText(ResourceUtil.getString(groupTitleKey));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        return group;
    }

    void setEnabledRadios(boolean state) {
        for (TestngTestSelector sel : this.m_launchSelectors) {
            sel.enableRadio(state);
        }
    }

    void setType(TestNGLaunchConfigurationConstants.LaunchType type) {
        if (type != this.m_typeOfTestRun) {
            this.m_typeOfTestRun = type;
            for (TestngTestSelector sel : this.m_launchSelectors) {
                boolean select = type == sel.getTestngType();
                sel.setRadioSelected(select);
                TestNGPlugin.bold((Control)sel.getRadioButton(), select);
            }
        }
        this.updateDialog();
    }

    private TestNGLaunchConfigurationConstants.LaunchType getType() {
        return this.m_typeOfTestRun;
    }

    public void updateDialog() {
        this.validatePage();
        this.updateLaunchConfigurationDialog();
    }

    public static void ppp(String s) {
        System.out.println("[TestNGMainTab] " + s);
    }

    public IJavaProject getSelectedProject() {
        return this.m_selectedProject;
    }

    protected Shell getShell() {
        return super.getShell();
    }

    protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return super.getLaunchConfigurationDialog();
    }
}

