/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.launch.tester.JavaTypeExtender;
import org.testng.eclipse.util.LaunchUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof StructuredSelection) {
            ArrayList types = Lists.newArrayList();
            IJavaProject javaProject = null;
            IProject project = null;
            Object[] objectArray = ((StructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r;
                Object obj = objectArray[n2];
                IJavaElement element = null;
                if (obj instanceof IMethod) {
                    this.run((IJavaElement)((IMethod)obj), mode);
                } else if (obj instanceof IJavaElement) {
                    element = (IJavaElement)obj;
                } else if (obj instanceof IAdaptable && (element = (IJavaElement)((IAdaptable)obj).getAdapter(IJavaElement.class)) == null && (r = (IResource)((IAdaptable)obj).getAdapter(IResource.class)) != null) {
                    project = r.getProject();
                }
                if (element != null) {
                    javaProject = element.getJavaProject();
                } else if (project instanceof IJavaProject) {
                    javaProject = (IJavaProject)project;
                }
                try {
                    this.maybeAddJavaElement(element, types);
                }
                catch (JavaModelException e) {
                    TestNGPlugin.log(e);
                }
                ++n2;
            }
            if (!types.isEmpty()) {
                LaunchUtil.launchTypesConfiguration(javaProject, types, mode);
            }
        }
    }

    private void maybeAddJavaElement(IJavaElement element, List<IType> units) throws JavaModelException {
        TestNGLaunchShortcut.p("Examining Java element:" + element);
        if (element != null) {
            if (element instanceof JavaProject) {
                JavaProject p = (JavaProject)element;
                IJavaElement[] iJavaElementArray = p.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement e = iJavaElementArray[n2];
                    this.maybeAddJavaElement(e, units);
                    ++n2;
                }
            } else if (element instanceof SourceType) {
                units.add((IType)((SourceType)element));
            } else if (element instanceof ICompilationUnit) {
                units.addAll(Arrays.asList(((ICompilationUnit)element).getTypes()));
            } else if (element instanceof PackageFragment) {
                PackageFragment p = (PackageFragment)element;
                ICompilationUnit[] iCompilationUnitArray = p.getCompilationUnits();
                int n = iCompilationUnitArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ICompilationUnit icu = iCompilationUnitArray[n3];
                    units.addAll(Arrays.asList(icu.getTypes()));
                    ++n3;
                }
            } else if (element instanceof PackageFragmentRoot) {
                PackageFragmentRoot pfr = (PackageFragmentRoot)element;
                IJavaElement[] iJavaElementArray = pfr.getChildren();
                int n = iJavaElementArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IJavaElement e = iJavaElementArray[n4];
                    if (JavaTypeExtender.isTest(e)) {
                        this.maybeAddJavaElement(e, units);
                    }
                    ++n4;
                }
            } else {
                TestNGLaunchShortcut.p("Ignoring non compilation unit selection: " + element);
            }
        }
    }

    private static void p(String s) {
        TestNGPlugin.log("[TestNGLaunchShortcut] " + s);
    }

    public void launch(IEditorPart editor, String mode) {
        ITypeRoot root = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput());
        if (root != null) {
            IMethod method = this.resolveSelectedMethod(editor, root);
            if (method != null) {
                this.run((IJavaElement)method, mode);
            } else if (root instanceof IJavaElement) {
                this.run((IJavaElement)root, mode);
            }
        }
    }

    private IMethod resolveSelectedMethod(IEditorPart editor, ITypeRoot root) {
        IJavaElement selectedElement;
        ITextSelection selectedText;
        block6: {
            block5: {
                try {
                    selectedText = this.getTextSelection(editor, root);
                    if (selectedText != null) break block5;
                    return null;
                }
                catch (JavaModelException javaModelException) {}
            }
            selectedElement = SelectionConverter.getElementAtOffset((ITypeRoot)root, (ITextSelection)selectedText);
            if (selectedElement instanceof IMethod) break block6;
            return null;
        }
        IMethod method = (IMethod)selectedElement;
        ISourceRange nameRange = method.getNameRange();
        if (nameRange.getOffset() <= selectedText.getOffset() && selectedText.getOffset() + selectedText.getLength() <= nameRange.getOffset() + nameRange.getLength()) {
            return method;
        }
        return null;
    }

    private ITextSelection getTextSelection(IEditorPart editor, ITypeRoot root) {
        ISelectionProvider selectionProvider = editor.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)selection;
    }

    protected void run(IJavaElement ije, String mode) {
        IJavaProject ijp = ije.getJavaProject();
        switch (ije.getElementType()) {
            case 4: {
                LaunchUtil.launchPackageConfiguration(ijp, (IPackageFragment)ije, mode);
                return;
            }
            case 5: {
                LaunchUtil.launchCompilationUnitConfiguration(ijp, Arrays.asList((ICompilationUnit)ije), mode);
                return;
            }
            case 7: {
                LaunchUtil.launchTypeConfiguration(ijp, (IType)ije, mode);
                return;
            }
            case 9: {
                LaunchUtil.launchMethodConfiguration(ijp, (IMethod)ije, mode);
                return;
            }
        }
    }
}

