/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.launch.MultiSelector;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.launch.TestNGMainTab;
import org.testng.eclipse.launch.components.Filters;
import org.testng.eclipse.launch.components.ITestContent;
import org.testng.eclipse.ui.util.ConfigurationHelper;
import org.testng.eclipse.ui.util.TypeParser;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.StringUtils;
import org.testng.eclipse.util.TestSearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupSelector
extends MultiSelector {
    private Map<String, List<String>> m_groupMap = Maps.newHashMap();

    GroupSelector(TestNGMainTab callback, Composite comp) {
        super(callback, comp, TestNGLaunchConfigurationConstants.LaunchType.GROUP, "TestNGMainTab.label.group", "CheckBoxTable.groups.title");
    }

    @Override
    protected Collection<String> getValues(ILaunchConfiguration configuration) {
        HashMap result = Maps.newHashMap();
        try {
            IJavaProject[] dependencies = new IJavaProject[]{};
            IJavaProject selectedProject = this.getCallback().getSelectedProject();
            try {
                String[] dependencyPrjNames = selectedProject.getRequiredProjectNames();
                if (dependencyPrjNames != null) {
                    dependencies = new IJavaProject[dependencyPrjNames.length];
                    int i = 0;
                    while (i < dependencyPrjNames.length) {
                        dependencies[i] = JDTUtil.getJavaProject(dependencyPrjNames[i]);
                        ++i;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
            Object[] projects = new Object[1 + dependencies.length];
            projects[0] = selectedProject;
            System.arraycopy(dependencies, 0, projects, 1, dependencies.length);
            IType[] types = TestSearchEngine.findTests((IRunnableContext)this.getCallback().getLaunchConfigurationDialog(), projects, Filters.SINGLE_TEST);
            int i = 0;
            while (i < types.length) {
                IType type;
                ITestContent content;
                Collection<String> groupNames;
                IType t = types[i];
                if (t instanceof IType && !(groupNames = (content = TypeParser.parseType(type = t)).getGroups()).isEmpty()) {
                    for (String groupName : groupNames) {
                        ArrayList<String> rtypes = (ArrayList<String>)result.get(groupName);
                        if (rtypes == null) {
                            rtypes = new ArrayList<String>();
                            result.put(groupName, rtypes);
                        }
                        rtypes.add(type.getFullyQualifiedName());
                    }
                }
                ++i;
            }
        }
        catch (InvocationTargetException e) {
            TestNGPlugin.log(e);
        }
        catch (InterruptedException e) {
            TestNGPlugin.log(e);
        }
        this.m_groupMap = result;
        return result.keySet();
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        List<String> groupNames = ConfigurationHelper.getGroups(configuration);
        this.setText(StringUtils.listToString(groupNames));
        this.m_groupMap.clear();
        List<String> groupClassNames = ConfigurationHelper.getGroupClasses(configuration);
        groupNames = ConfigurationHelper.getGroups(configuration);
        if (groupNames != null) {
            int i = 0;
            while (i < groupNames.size()) {
                this.m_groupMap.put(groupNames.get(i), groupClassNames);
                ++i;
            }
            this.getValueMap().putAll(this.m_groupMap);
        }
    }

    @Override
    public Map<String, List<String>> onSelect(String[] selectedValues) {
        HashMap result = Maps.newHashMap();
        int i = 0;
        while (i < selectedValues.length) {
            result.put(selectedValues[i], this.m_groupMap.get(selectedValues[i]));
            ++i;
        }
        return result;
    }
}

