/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.buildpath;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.testng.eclipse.buildpath.BuildPathSupport;

public class TestNGContainerInitializer
extends ClasspathContainerInitializer {
    public static final String TESTNG_CONTAINER_ID = "org.testng.TESTNG_CONTAINER";
    public static final IPath TESTNG_PATH = new Path("org.testng.TESTNG_CONTAINER");

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (TestNGContainerInitializer.isValidTestNGContainerPath(containerPath)) {
            IClasspathEntry entry = null;
            entry = BuildPathSupport.getTestNGLibraryEntry();
            IClasspathEntry[] entries = entry != null ? new IClasspathEntry[]{entry} : new IClasspathEntry[]{};
            TestNGContainer testNGContainer = new TestNGContainer(containerPath, entries);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{testNGContainer}, null);
        }
    }

    private static boolean isValidTestNGContainerPath(IPath path) {
        return path != null && path.segmentCount() == 1 && TESTNG_CONTAINER_ID.equals(path.segment(0));
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{containerSuggestion}, null);
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }

    private static class TestNGContainer
    implements IClasspathContainer {
        private final IClasspathEntry[] fEntries;
        private final IPath fPath;

        public TestNGContainer(IPath path, IClasspathEntry[] entries) {
            this.fPath = path;
            this.fEntries = entries;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fEntries;
        }

        public String getDescription() {
            return "TestNG";
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.fPath;
        }
    }
}

