/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.springframework.ide.eclipse.config.graph.parts.ActivityDiagramPart;
import org.springframework.ide.eclipse.config.graph.parts.GraphLayoutManager;
import org.springframework.ide.eclipse.config.graph.parts.GraphXYLayout;
import org.springframework.ide.eclipse.config.graph.policies.GraphXYLayoutPolicy;
import org.springframework.ide.eclipse.config.graph.policies.StructuredActivityLayoutEditPolicy;

public class DelegatingLayoutManager
implements LayoutManager {
    private final ActivityDiagramPart diagram;
    private LayoutManager activeLayoutManager;
    private final GraphLayoutManager graphLayoutManager;
    private final GraphXYLayout xyLayoutManager;

    DelegatingLayoutManager(ActivityDiagramPart diagram) {
        this.diagram = diagram;
        this.graphLayoutManager = new GraphLayoutManager(diagram, diagram.getDirection());
        this.xyLayoutManager = new GraphXYLayout(diagram, diagram.getDirection());
        this.activeLayoutManager = this.graphLayoutManager;
    }

    public LayoutManager getActiveLayoutManager() {
        return this.activeLayoutManager;
    }

    public Object getConstraint(IFigure figure) {
        return this.activeLayoutManager.getConstraint(figure);
    }

    public Dimension getMinimumSize(IFigure figure, int wHint, int hHint) {
        return this.activeLayoutManager.getMinimumSize(figure, wHint, hHint);
    }

    public Dimension getPreferredSize(IFigure figure, int wHint, int hHint) {
        return this.activeLayoutManager.getPreferredSize(figure, wHint, hHint);
    }

    public void invalidate() {
        this.activeLayoutManager.invalidate();
    }

    public void layout(IFigure figure) {
        if (this.diagram.isManualLayout()) {
            if (this.diagram.isFirstManualLayout()) {
                this.setLayoutManager(figure, (LayoutManager)this.graphLayoutManager);
                this.activeLayoutManager.layout(figure);
            }
            this.diagram.setBoundsOnFigure(true);
            this.setLayoutManager(figure, (LayoutManager)this.xyLayoutManager);
            this.activeLayoutManager.layout(figure);
        } else {
            this.setLayoutManager(figure, (LayoutManager)this.graphLayoutManager);
            this.activeLayoutManager.layout(figure);
        }
    }

    public void remove(IFigure figure) {
        this.activeLayoutManager.remove(figure);
    }

    public void setConstraint(IFigure figure, Object constraint) {
        this.activeLayoutManager.setConstraint(figure, constraint);
    }

    public void setLayoutManager(IFigure figure, LayoutManager layoutManager) {
        figure.setLayoutManager(layoutManager);
        this.activeLayoutManager = layoutManager;
        if (layoutManager == this.xyLayoutManager) {
            this.diagram.installEditPolicy("LayoutEditPolicy", (EditPolicy)new GraphXYLayoutPolicy());
        } else {
            this.diagram.installEditPolicy("LayoutEditPolicy", (EditPolicy)new StructuredActivityLayoutEditPolicy());
        }
    }

    public void setXYLayoutConstraint(IFigure figure, Rectangle constraint) {
        this.xyLayoutManager.setConstraint(figure, constraint);
    }
}

