/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model.commands;

import java.util.List;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.config.graph.model.commands.RenameActivityCommand;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefactoringRenameCommand
extends RenameActivityCommand {
    private IDOMDocument doc;

    public RefactoringRenameCommand(ITextEditor textEditor) {
        super(textEditor);
    }

    @Override
    public boolean canExecute() {
        if (super.canExecute()) {
            if (this.oldName == null || this.oldName.trim().length() == 0 || this.oldName.equals(this.name)) {
                return false;
            }
            if (this.input.getOwnerDocument() instanceof IDOMDocument) {
                this.doc = (IDOMDocument)this.input.getOwnerDocument();
                return true;
            }
        }
        return false;
    }

    @Override
    public void execute() {
        IDOMModel model = this.doc.getModel();
        if (model != null) {
            model.beginRecording((Object)this);
            super.execute();
            this.searchElements(this.doc.getDocumentElement());
            model.endRecording((Object)this);
        }
    }

    protected abstract List<String> getAttributesToCheck();

    private void searchAttributes(Node parent) {
        NamedNodeMap attributes = parent.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node attr = attributes.item(i);
                if (this.getAttributesToCheck().contains(attr.getNodeName()) && this.oldName.equals(attr.getNodeValue())) {
                    attr.setNodeValue(this.name);
                }
                ++i;
            }
        }
    }

    private void searchElements(Node parent) {
        NodeList elements = parent.getChildNodes();
        int i = 0;
        while (i < elements.getLength()) {
            Node elementNode = elements.item(i);
            this.searchAttributes(elementNode);
            this.searchElements(elementNode);
            ++i;
        }
    }
}

