/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.extensions.PageAdaptersExtensionPointConstants;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.IModelFactory;
import org.springframework.ide.eclipse.config.graph.model.Messages;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StructuredActivity
extends Activity {
    static final long serialVersionUID = 1L;
    private static int count;
    protected List<Activity> children = new ArrayList<Activity>();

    public StructuredActivity() {
    }

    public StructuredActivity(IDOMElement input, AbstractConfigGraphDiagram diagram) {
        super(input, diagram);
    }

    public void addChild(Activity child) {
        this.addChild(child, -1);
    }

    public void addChild(Activity child, int index) {
        if (index >= 0) {
            this.children.add(index, child);
        } else {
            this.children.add(child);
        }
        this.extendedAddChild(child, index);
        this.fireStructureChange("children", child);
    }

    protected void extendedAddChild(Activity child, int index) {
        IDOMModel model;
        IDOMDocument document = (IDOMDocument)this.getInput().getOwnerDocument();
        IDOMElement childElem = child.getInput();
        if (childElem == null) {
            childElem = (IDOMElement)document.createElement(child.getInputName());
            childElem.setPrefix(ConfigCoreUtils.getPrefixForNamespaceUri((IDOMDocument)document, (String)this.getDiagram().getNamespaceUri()));
        }
        if ((model = document.getModel()) != null) {
            model.beginRecording((Object)this);
            this.getInput().appendChild((Node)childElem);
            this.getDiagram().getXmlProcessor().insertDefaultAttributes(childElem);
            this.formatter.formatNode((Node)childElem);
            this.formatter.formatNode(childElem.getParentNode());
            model.endRecording((Object)this);
        }
    }

    protected void extendedRemoveChild(Activity child) {
        IDOMDocument document = (IDOMDocument)this.getInput().getOwnerDocument();
        IDOMElement childElem = child.getInput();
        if (childElem != null) {
            IDOMModel model = document.getModel();
            Node parent = childElem.getParentNode();
            if (model != null && parent != null) {
                model.beginRecording((Object)this);
                parent.removeChild((Node)childElem);
                this.formatter.formatNode(parent);
                model.endRecording((Object)this);
            }
        }
    }

    public List<Activity> getChildren() {
        return this.children;
    }

    protected List<Activity> getChildrenFromXml() {
        String defaultUri = this.getDiagram().getNamespaceUri();
        ArrayList<Activity> list = new ArrayList<Activity>();
        NodeList children = this.getInput().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof IDOMElement) {
                IDOMElement childElem = (IDOMElement)child;
                if (defaultUri != null && defaultUri.equals(child.getNamespaceURI())) {
                    this.getDiagram().getModelFactory().getChildrenFromXml(list, childElem, this);
                } else {
                    for (IConfigurationElement config : this.getDiagram().getGraphicalEditor().getAdapterDefinitions()) {
                        String uri = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI);
                        if (!uri.equals(child.getNamespaceURI())) continue;
                        try {
                            Object obj = config.createExecutableExtension(PageAdaptersExtensionPointConstants.ATTR_MODEL_FACTORY);
                            if (!(obj instanceof IModelFactory)) continue;
                            IModelFactory factory = (IModelFactory)obj;
                            factory.getChildrenFromXml(list, childElem, this);
                        }
                        catch (CoreException e) {
                            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.graph", Messages.AbstractConfigFlowDiagram_ERROR_CREATING_GRAPH, (Throwable)e));
                        }
                    }
                }
                this.getDiagram().getModelFactory().getGenericChildrenFromXml(list, childElem, this);
            }
            ++i;
        }
        return list;
    }

    public String getNewID() {
        return Integer.toString(count++);
    }

    public void removeChild(Activity child) {
        this.children.remove(child);
        this.extendedRemoveChild(child);
        this.fireStructureChange("children", child);
    }

    protected void updateChildrenFromXml() {
        List<Activity> list = this.getChildrenFromXml();
        ArrayList<Activity> workingCopy = new ArrayList<Activity>();
        workingCopy.addAll(list);
        for (Activity activity : list) {
            int i = 0;
            while (i < this.children.size()) {
                Activity child = this.children.get(i);
                if (activity.equals(child)) {
                    int index = list.indexOf(activity);
                    workingCopy.remove(activity);
                    workingCopy.add(index, child);
                }
                ++i;
            }
        }
        this.children = workingCopy;
        this.getModelRegistry().addAll(this.children);
        for (Activity activity : this.children) {
            activity.incomings.clear();
            activity.outgoings.clear();
            activity.internalSetName();
            if (!(activity instanceof StructuredActivity)) continue;
            ((StructuredActivity)activity).updateChildrenFromXml();
        }
    }

    @Override
    protected void updateTransitionsFromXml() {
        super.updateTransitionsFromXml();
        for (Activity child : this.children) {
            child.updateTransitionsFromXml();
        }
    }
}

