/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphModelElement;
import org.springframework.ide.eclipse.config.graph.model.ParallelActivity;
import org.springframework.ide.eclipse.config.graph.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Activity
extends AbstractConfigGraphModelElement {
    static final long serialVersionUID = 1L;
    protected List<Transition> incomings = new ArrayList<Transition>();
    protected List<Transition> outgoings = new ArrayList<Transition>();
    private int sortIndex;

    public Activity() {
    }

    public Activity(IDOMElement input, AbstractConfigGraphDiagram diagram) {
        super(input, diagram);
    }

    public void addIncoming(Transition transition) {
        if (!this.incomings.contains(transition)) {
            this.incomings.add(transition);
        }
        this.fireStructureChange("incomings", transition);
    }

    public void addOutgoing(Transition transition) {
        if (!this.outgoings.contains(transition)) {
            this.outgoings.add(transition);
        }
        this.fireStructureChange("outgoings", transition);
    }

    public List<Transition> getIncomingTransitions() {
        return this.incomings;
    }

    protected List<Transition> getIncomingTransitionsFromXml() {
        ArrayList<Transition> list = new ArrayList<Transition>();
        List<Activity> registry = this.getDiagram().getModelRegistry();
        for (Activity activity : registry) {
            if (activity instanceof ParallelActivity) continue;
            this.getDiagram().getTransitionsFromXml(this, activity, list, this.getPrimaryIncomingAttributes(), true, true);
            this.getDiagram().getTransitionsFromXml(this, activity, list, this.getSecondaryIncomingAttributes(), true, false);
        }
        return list;
    }

    public List<Transition> getOutgoingTransitions() {
        return this.outgoings;
    }

    protected List<Transition> getOutgoingTransitionsFromXml() {
        ArrayList<Transition> list = new ArrayList<Transition>();
        List<Activity> registry = this.getDiagram().getModelRegistry();
        for (Activity activity : registry) {
            if (activity instanceof ParallelActivity) continue;
            this.getDiagram().getTransitionsFromXml(this, activity, list, this.getPrimaryOutgoingAttributes(), false, true);
            this.getDiagram().getTransitionsFromXml(this, activity, list, this.getSecondaryOutgoingAttributes(), false, false);
        }
        return list;
    }

    public List<String> getPrimaryIncomingAttributes() {
        return new ArrayList<String>();
    }

    public List<String> getPrimaryOutgoingAttributes() {
        return new ArrayList<String>();
    }

    public List<String> getSecondaryIncomingAttributes() {
        return new ArrayList<String>();
    }

    public List<String> getSecondaryOutgoingAttributes() {
        return new ArrayList<String>();
    }

    public int getSortIndex() {
        if (this.getInput() != null) {
            return this.getInput().getStartOffset();
        }
        return -1;
    }

    public void removeIncoming(Transition transition) {
        this.incomings.remove(transition);
        this.fireStructureChange("incomings", transition);
    }

    public void removeOutgoing(Transition transition) {
        this.outgoings.remove(transition);
        this.fireStructureChange("outgoings", transition);
    }

    public void setSortIndex(int i) {
        this.sortIndex = i;
    }

    protected void updateTransitionsFromXml() {
        this.getIncomingTransitionsFromXml();
        this.getOutgoingTransitionsFromXml();
    }
}

