/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.actions;

import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.springframework.ide.eclipse.config.graph.AbstractConfigGraphicalEditor;
import org.springframework.ide.eclipse.config.graph.ConfigGraphPlugin;
import org.springframework.ide.eclipse.config.graph.actions.Messages;

public class ResetManualLayoutAction
extends SelectionAction
implements IPropertyChangeListener {
    public static String RESET_LAYOUT_ID = "ResetLayout";
    private final IPreferenceStore prefStore;

    public ResetManualLayoutAction(IWorkbenchPart part) {
        super(part);
        this.setId(RESET_LAYOUT_ID);
        this.setText(Messages.ResetManualLayoutAction_RESET_LAYOUT_ACTION_LABEL);
        this.prefStore = ConfigGraphPlugin.getDefault().getPreferenceStore();
        this.prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected boolean calculateEnabled() {
        return this.prefStore.getBoolean("com.springsource.config.flow.prefs.manualLayout");
    }

    public void dispose() {
        if (this.prefStore != null) {
            this.prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("com.springsource.config.flow.prefs.manualLayout".equals(property)) {
            this.setEnabled(this.calculateEnabled());
        }
    }

    public void run() {
        IWorkbenchPart editor = this.getWorkbenchPart();
        if (editor instanceof AbstractConfigGraphicalEditor) {
            AbstractConfigGraphicalEditor graph = (AbstractConfigGraphicalEditor)editor;
            String uri = graph.getNamespaceUri();
            this.prefStore.firePropertyChangeEvent("com.springsource.config.flow.properties.resetLayout", null, (Object)uri);
        }
    }
}

