/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.content.core;

import java.io.File;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.springsource.ide.eclipse.commons.content.core.ContentManager;
import org.springsource.ide.eclipse.commons.content.core.util.Descriptor;

public class DescriptorMatcher {
    private final ContentManager manager;
    private final Dictionary<Object, Object> environment = new Hashtable<Object, Object>(System.getProperties());
    private File installDirectory;
    private Version version;

    public DescriptorMatcher(ContentManager manager) {
        String versionString;
        this.manager = manager;
        Bundle bundle = Platform.getBundle((String)"org.springsource.sts");
        if (bundle != null && (versionString = (String)bundle.getHeaders().get("Bundle-Version")) != null) {
            this.version = new Version(versionString);
            this.environment.put("org.springsource.sts.version", this.version.toString());
            this.environment.put("org.springsource.sts.version.major", this.version.getMajor());
            this.environment.put("org.springsource.sts.version.minor", this.version.getMinor());
            this.environment.put("org.springsource.sts.version.micro", this.version.getMicro());
        }
    }

    public DescriptorMatcher(File installDirectory) {
        this((ContentManager)null);
        this.installDirectory = installDirectory;
    }

    public Map<Object, Object> getEnvironment() {
        return Collections.unmodifiableMap((Map)((Object)this.environment));
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean match(Descriptor descriptor) {
        File baseDirectory;
        File directory;
        if (this.version != null && descriptor.getRequires() != null) {
            try {
                VersionRange versionRange = new VersionRange(descriptor.getRequires());
                if (!versionRange.isIncluded(this.version)) {
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (descriptor.getFilter() != null) {
            try {
                Filter filter = FrameworkUtil.createFilter((String)descriptor.getFilter());
                return filter.match(this.environment);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        return !descriptor.isLocal() || (directory = new File(baseDirectory = this.installDirectory == null ? this.manager.getInstallDirectory() : this.installDirectory, String.valueOf(descriptor.getId()) + "-" + descriptor.getVersion())).exists();
    }
}

