/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.osgi.framework.Bundle;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.server.protocol.completions.Parameter;
import tern.server.protocol.completions.TernCompletionItem;
import tern.utils.StringUtils;

public class HTMLTernPrinter {
    private static String fgStyleSheet;

    public static String getAdditionalProposalInfo(TernCompletionItem item, Boolean guess) {
        StringBuffer buffer = new StringBuffer();
        ImageDescriptor descriptor = TernUIPlugin.getTernDescriptorManager().getImageDescriptor(item);
        HTMLTernPrinter.startPage(buffer, HTMLTernPrinter.getTitle(item), descriptor);
        HTMLTernPrinter.addDocContent(buffer, item.getDoc());
        HTMLTernPrinter.startDefinitionList(buffer);
        HTMLTernPrinter.addParametersContent(buffer, item.getParameters());
        HTMLTernPrinter.addReturnTypeContent(buffer, item.getJsType());
        HTMLTernPrinter.addOriginContent(buffer, item.getOrigin());
        HTMLTernPrinter.addGuessContent(buffer, guess);
        HTMLTernPrinter.addURLContent(buffer, item.getURL());
        HTMLTernPrinter.endDefinitionList(buffer);
        HTMLTernPrinter.endPage(buffer);
        return buffer.toString();
    }

    public static void addGuessContent(StringBuffer buffer, Boolean guess) {
        if (guess != null) {
            HTMLTernPrinter.addDefinitionListItem(buffer, "Guess?", guess.toString());
        }
    }

    public static void addReturnTypeContent(StringBuffer buffer, String returnType) {
        if (!StringUtils.isEmpty((String)returnType)) {
            buffer.append("<dt><b>Returns:</b></dt>");
            buffer.append("<dd>");
            buffer.append("<code>");
            buffer.append(returnType);
            buffer.append("</code>");
            buffer.append("</dd>");
        }
    }

    public static void addParametersContent(StringBuffer buffer, List<Parameter> parameters) {
        if (parameters != null) {
            buffer.append("<dt><b>Parameters:</b></dt>");
            for (Parameter parameter : parameters) {
                buffer.append("<dd>");
                if (!parameter.isRequired()) {
                    buffer.append("[");
                }
                buffer.append("<code>");
                buffer.append(parameter.getName());
                buffer.append("</code>");
                if (!parameter.isRequired()) {
                    buffer.append("]");
                }
                buffer.append(" - ");
                buffer.append("<code>");
                buffer.append(parameter.getType());
                buffer.append("</code>");
                buffer.append("</dd>");
            }
        }
    }

    public static String getTitle(TernCompletionItem item) {
        return "<b>" + item.getSignature() + "</b>";
    }

    public static void addDocContent(StringBuffer buffer, String doc) {
        buffer.append("<p>");
        if (doc != null) {
            buffer.append(doc);
        }
        buffer.append("</p>");
    }

    public static void endPage(StringBuffer buffer) {
        HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)HTMLTernPrinter.getStyleSheet());
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
    }

    public static void addOriginContent(StringBuffer buffer, String origin) {
        HTMLTernPrinter.addDefinitionListItem(buffer, "Origin", origin);
    }

    public static void addDefinitionListItem(StringBuffer buffer, String name, String value) {
        if (!StringUtils.isEmpty((String)value)) {
            buffer.append("<dt><b>");
            buffer.append(name);
            buffer.append(":</b></dt>");
            buffer.append("<dd>");
            buffer.append(value);
            buffer.append("</dd>");
        }
    }

    public static void addDefinitionListItem(StringBuffer buffer, String name, Collection<String> values) {
        if (values != null && !values.isEmpty()) {
            HTMLTernPrinter.addDefinitionListItem(buffer, name, Arrays.toString(values.toArray()));
        }
    }

    public static void addURLContent(StringBuffer buffer, String url) {
        if (!StringUtils.isEmpty((String)url)) {
            buffer.append("<dt><b>See:</b></dt>");
            buffer.append("<dd>");
            buffer.append("<a href=\"");
            buffer.append(url);
            buffer.append("\" >");
            buffer.append(url);
            buffer.append("</a>");
            buffer.append("</dd>");
        }
    }

    public static void startDefinitionList(StringBuffer buffer) {
        buffer.append("<dl>");
    }

    public static void endDefinitionList(StringBuffer buffer) {
        buffer.append("</dl>");
    }

    private static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = HTMLTernPrinter.loadStyleSheet("/TernHoverStyleSheet.css");
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.dialogfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet(String styleSheetName) {
        Bundle bundle = Platform.getBundle((String)"tern.eclipse.ide.ui");
        URL styleSheetURL = bundle.getEntry(styleSheetName);
        if (styleSheetURL == null) {
            return null;
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
        StringBuffer buffer = new StringBuffer(1500);
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line);
            buffer.append('\n');
            line = reader.readLine();
        }
        FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.dialogfont")[0];
        String string = HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException ex) {
            try {
                Trace.trace((byte)3, "Error while loading style sheets", ex);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return "";
        }
    }

    public static void startPage(StringBuffer buf, String title, ImageDescriptor descriptor) {
        int imageWidth = 16;
        int imageHeight = 16;
        int labelLeft = 20;
        int labelTop = 2;
        buf.append("<div style='word-wrap: break-word; position: relative; ");
        String imageSrcPath = HTMLTernPrinter.getImageURL(descriptor);
        if (imageSrcPath != null) {
            buf.append("margin-left: ").append(labelLeft).append("px; ");
            buf.append("padding-top: ").append(labelTop).append("px; ");
        }
        buf.append("'>");
        if (imageSrcPath != null) {
            StringBuffer imageStyle = new StringBuffer("border:none; position: absolute; ");
            imageStyle.append("width: ").append(imageWidth).append("px; ");
            imageStyle.append("height: ").append(imageHeight).append("px; ");
            imageStyle.append("left: ").append(-labelLeft - 1).append("px; ");
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            String tooltip = "";
            buf.append("<span ").append(tooltip).append("style=\"").append(imageStyle).append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(imageSrcPath).append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img ").append(tooltip).append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img ").append(tooltip).append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<![endif]-->\n");
        }
        buf.append(title);
        buf.append("</div>");
        buf.append("<hr />");
    }

    private static String getImageURL(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        String imageName = null;
        URL imageUrl = TernUIPlugin.getTernDescriptorManager().getImageURL(descriptor);
        if (imageUrl != null) {
            imageName = imageUrl.toExternalForm();
        }
        return imageName;
    }
}

