/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.controls;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import tern.TernException;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.ui.TernUIMessages;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.controls.DependenciesPanel;
import tern.eclipse.ide.internal.ui.controls.DetailsPanel;
import tern.eclipse.ide.internal.ui.controls.OptionsPanel;
import tern.eclipse.ide.internal.ui.properties.AbstractTableBlock;
import tern.eclipse.ide.internal.ui.viewers.TernModuleVersionEditingSupport;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.viewers.TernModuleLabelProvider;
import tern.metadata.TernModuleMetadata;
import tern.server.ITernDef;
import tern.server.ITernModule;
import tern.server.ITernPlugin;
import tern.utils.TernModuleHelper;

public class TernModulesBlock
extends AbstractTableBlock {
    private final String tableLabel;
    private final IProject project;
    private Composite fControl;
    private final List<ITernModule> ternModules = new ArrayList<ITernModule>();
    private CheckboxTableViewer tableViewer;
    private DetailsPanel detailsPanel;
    private DependenciesPanel dependenciesPanel;
    private OptionsPanel optionsPanel;
    private TabItem optionsTabItem;
    private TabFolder tabFolder;
    private TabItem detailsTabItem;
    private Button selectDependenciesCheckbox;

    public TernModulesBlock(IProject project, String tableLabel) {
        this.project = project;
        this.tableLabel = tableLabel;
    }

    public void createControl(Composite ancestor) {
        GridData data;
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        this.fControl = parent;
        if (this.tableLabel != null) {
            Composite header = new Composite(parent, 0);
            data = new GridData();
            data.horizontalSpan = 2;
            header.setLayoutData((Object)data);
            header.setLayout((Layout)new GridLayout(2, false));
            Label tableLabel = new Label(header, 0);
            tableLabel.setText(this.tableLabel);
            tableLabel.setLayoutData((Object)new GridData(768));
            tableLabel.setFont(font);
            this.selectDependenciesCheckbox = new Button(header, 32);
            this.selectDependenciesCheckbox.setSelection(true);
        }
        SashForm sashForm = new SashForm(parent, 65792);
        data = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)data);
        this.createModulesMaster((Composite)sashForm);
        this.createModulesDetails((Composite)sashForm);
        Dialog.applyDialogFont((Control)parent);
    }

    private void createModulesMaster(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        Table table = new Table(parent, 68128);
        GridData data = new GridData(1808);
        data.widthHint = 350;
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new CheckboxTableViewer(table);
        TableViewerColumn nameColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        nameColumn.getColumn().setWidth(180);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setText(TernUIMessages.TernModulesBlock_moduleName);
        nameColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TernModulesBlock.this.sortByName();
            }
        });
        TableViewerColumn versionColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        versionColumn.getColumn().setWidth(100);
        versionColumn.getColumn().setResizable(true);
        versionColumn.getColumn().setText(TernUIMessages.TernModulesBlock_moduleVersion);
        versionColumn.setEditingSupport((EditingSupport)new TernModuleVersionEditingSupport((ColumnViewer)this.tableViewer));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)TernModuleLabelProvider.getInstance());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){
            private boolean checkUpdating;

            public void checkStateChanged(CheckStateChangedEvent e) {
                if (this.checkUpdating) {
                    return;
                }
                try {
                    ITernModule module;
                    TernModuleMetadata metadata;
                    this.checkUpdating = true;
                    if (e.getChecked() && TernModulesBlock.this.isSelectDependencies() && (metadata = (module = (ITernModule)e.getElement()).getMetadata()) != null) {
                        ITernModule dependencyModule = null;
                        for (String moduleName : metadata.getDependencies()) {
                            dependencyModule = TernCorePlugin.getTernServerTypeManager().findTernModule(moduleName);
                            if (dependencyModule == null || TernModulesBlock.this.tableViewer.getChecked((Object)dependencyModule)) continue;
                            TernModulesBlock.this.tableViewer.setChecked((Object)dependencyModule, true);
                        }
                    }
                }
                finally {
                    this.checkUpdating = false;
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (!e.getSelection().isEmpty()) {
                    ITernModule module = (ITernModule)((IStructuredSelection)e.getSelection()).getFirstElement();
                    TernModulesBlock.this.refreshModule(module);
                } else {
                    TernModulesBlock.this.refreshModule(null);
                }
            }
        });
        this.restoreColumnSettings();
    }

    private void createModulesDetails(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        GridData data = new GridData(768);
        data.heightHint = 80;
        this.tabFolder.setLayoutData((Object)data);
        this.detailsPanel = new DetailsPanel((Composite)this.tabFolder, this.project);
        this.detailsTabItem = new TabItem(this.tabFolder, 0);
        this.detailsTabItem.setControl((Control)this.detailsPanel);
        this.detailsTabItem.setText(TernUIMessages.TernModulesBlock_detailsTabLabel);
        this.dependenciesPanel = new DependenciesPanel((Composite)this.tabFolder, this.project);
        TabItem dependenciesTabItem = new TabItem(this.tabFolder, 0);
        dependenciesTabItem.setControl((Control)this.dependenciesPanel);
        dependenciesTabItem.setText(TernUIMessages.TernModulesBlock_dependenciesTabLabel);
        this.optionsPanel = new OptionsPanel((Composite)this.tabFolder, this.project);
    }

    private void refreshModule(ITernModule module) {
        if (TernModuleHelper.hasOptions((ITernModule)module)) {
            if (this.optionsTabItem == null) {
                this.optionsTabItem = new TabItem(this.tabFolder, 0);
                this.optionsTabItem.setControl((Control)this.optionsPanel);
                this.optionsTabItem.setText(TernUIMessages.TernModulesBlock_optionsTabLabel);
            }
            this.optionsPanel.refresh(module);
        } else {
            if (this.optionsTabItem != null) {
                this.optionsTabItem.dispose();
            }
            this.optionsTabItem = null;
        }
        this.detailsPanel.refresh(module);
        this.dependenciesPanel.refresh(module);
        this.tabFolder.setSelection(this.detailsTabItem);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.removeSelectionChangedListener(listener);
    }

    private void sortByName() {
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ITernModule && e2 instanceof ITernModule) {
                    ITernModule left = (ITernModule)e1;
                    ITernModule right = (ITernModule)e2;
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setTernModules(ITernModule[] vms) {
        this.ternModules.clear();
        ITernModule[] iTernModuleArray = vms;
        int n = vms.length;
        int n2 = 0;
        while (n2 < n) {
            ITernModule element = iTernModuleArray[n2];
            this.ternModules.add(element);
            ++n2;
        }
        this.tableViewer.setInput(this.ternModules);
    }

    public Object[] getCheckedModules() {
        return this.tableViewer.getCheckedElements();
    }

    public void setCheckedModules(Object[] selectedModules) {
        this.tableViewer.setCheckedElements(selectedModules);
    }

    @Override
    protected void setSortColumn(int column) {
        switch (column) {
            case 1: {
                this.sortByName();
            }
        }
        super.setSortColumn(column);
    }

    @Override
    protected Table getTable() {
        return this.tableViewer.getTable();
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        return TernUIPlugin.getDefault().getDialogSettings();
    }

    @Override
    protected String getQualifier() {
        return "";
    }

    public void loadModules() {
        try {
            ITernModule[] defaultModules;
            ArrayList<ITernModule> allModules = new ArrayList<ITernModule>();
            ITernModule[] iTernModuleArray = defaultModules = TernCorePlugin.getTernServerTypeManager().getTernModulesGroupByType();
            int n = defaultModules.length;
            int n2 = 0;
            while (n2 < n) {
                ITernModule defaultModule = iTernModuleArray[n2];
                allModules.add(defaultModule);
                ++n2;
            }
            ArrayList<ITernModule> initialModules = null;
            if (this.project != null) {
                IIDETernProject ternProject = TernCorePlugin.getTernProject((IProject)this.project);
                initialModules = new ArrayList<ITernModule>();
                JsonValue options = null;
                JsonObject plugins = ternProject.getPlugins();
                for (String name : plugins.names()) {
                    options = plugins.get(name);
                    ITernPlugin plugin = TernCorePlugin.getTernServerTypeManager().findTernPlugin(name.toString());
                    this.updateInitialModule((ITernModule)plugin, options, allModules, initialModules);
                }
                JsonArray defs = ternProject.getLibs();
                for (JsonValue name : defs) {
                    ITernDef def = TernCorePlugin.getTernServerTypeManager().findTernDef(name.asString());
                    this.updateInitialModule((ITernModule)def, null, allModules, initialModules);
                }
            }
            this.setTernModules(allModules.toArray(ITernModule.EMPTY_MODULE));
            if (initialModules != null) {
                this.setCheckedModules(initialModules.toArray());
            }
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Error while loading plugins.", e);
        }
    }

    private void updateInitialModule(ITernModule module, JsonValue options, List<ITernModule> allModules, List<ITernModule> initialModules) {
        if (module != null) {
            if (!TernModuleHelper.isConfigurableModule((ITernModule)module)) {
                initialModules.add(module);
            } else {
                try {
                    initialModules.add((ITernModule)TernModuleHelper.findConfigurable((ITernModule)module, (JsonValue)options, allModules));
                }
                catch (TernException e) {
                    Trace.trace((byte)3, "Error while finding configurable module.", e);
                }
            }
        }
    }

    private boolean isSelectDependencies() {
        return this.selectDependenciesCheckbox != null && this.selectDependenciesCheckbox.getSelection();
    }
}

