/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.springiderules;

import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.validation.AbstractXmlValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.beans.core.model.validation.IXmlValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnnecessaryValueElementRule
extends AbstractXmlValidationRule
implements IValidationRule<IBeansModelElement, IBeansValidationContext> {
    private static final int DEFAULT_MIN_VALUE_LENGTH = 40;
    public static final String ERROR_ID = "unnecessaryValueElement";
    private int minValueLength = 40;

    public void setMinValueLength(int minValueLength) {
        this.minValueLength = minValueLength;
    }

    protected boolean supports(Node node) {
        return node.getNodeName().equals("value") && node.getParentNode().getNodeName().equals("property");
    }

    protected void validate(Node node, IXmlValidationContext context) {
        if (node.getFirstChild() != null && !(node.getFirstChild() instanceof CDATASection) && node.getFirstChild().getNodeValue().length() < this.minValueLength) {
            context.info(node, ERROR_ID, "Consider using a value=\"" + node.getFirstChild().getNodeValue().trim() + "\" attribute for short literals instead of a value element", new ValidationProblemAttribute[0]);
        }
    }
}

