/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.monitor.core;

import java.util.Date;
import org.eclipse.core.runtime.Assert;

public class InteractionEvent {
    private final Kind kind;
    private final Date date;
    private final String pluginId;
    private final String eventId;
    private final String details;
    public static final String ID_UNKNOWN = "?";

    public InteractionEvent(Kind kind, String pluginId, String eventId, String details, Date startDate) {
        Assert.isNotNull((Object)((Object)kind));
        Assert.isNotNull((Object)pluginId);
        Assert.isNotNull((Object)eventId);
        this.kind = kind;
        this.pluginId = pluginId != null ? pluginId.intern() : null;
        this.eventId = eventId != null ? eventId.intern() : null;
        this.details = details != null ? details.intern() : null;
        this.date = startDate;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof InteractionEvent)) {
            return false;
        }
        InteractionEvent event = (InteractionEvent)object;
        return (this.date == null ? event.date == null : this.date.equals(event.date)) && (this.kind == null ? event.kind == null : this.kind.equals((Object)event.kind)) && (this.pluginId == null ? event.pluginId == null : this.pluginId.equals(event.pluginId)) && (this.eventId == null ? event.eventId == null : this.eventId.equals(event.eventId)) && (this.details == null ? event.details == null : this.details.equals(event.details));
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.date != null) {
            hashCode += this.date.hashCode();
        }
        if (this.kind != null) {
            hashCode += this.kind.hashCode();
        }
        if (this.pluginId != null) {
            hashCode += this.pluginId.hashCode();
        }
        if (this.eventId != null) {
            hashCode += this.eventId.hashCode();
        }
        if (this.details != null) {
            hashCode += this.details.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        return "(date: " + this.date + ", kind: " + (Object)((Object)this.kind) + ", pluginId: " + this.pluginId + ", eventId: " + this.eventId + ", details: " + this.details + ")";
    }

    public Date getDate() {
        return this.date;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getDetails() {
        return this.details;
    }

    public static InteractionEvent makePreference(String idPlugin, String string, String value) {
        return new InteractionEvent(Kind.PREFERENCE, idPlugin, string, value, new Date());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        ACTION,
        COMMAND,
        JOB,
        PREFERENCE,
        VIEW,
        PERSPECTIVE;


        public String toString() {
            switch (this) {
                case COMMAND: {
                    return "command";
                }
                case PREFERENCE: {
                    return "preference";
                }
                case ACTION: {
                    return "action";
                }
                case VIEW: {
                    return "view";
                }
                case JOB: {
                    return "job";
                }
                case PERSPECTIVE: {
                    return "perspective";
                }
            }
            return "null";
        }

        public static Kind fromString(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("command")) {
                return COMMAND;
            }
            if (string.equals("preference")) {
                return PREFERENCE;
            }
            if (string.equals("action")) {
                return ACTION;
            }
            if (string.equals("job")) {
                return JOB;
            }
            if (string.equals("view")) {
                return VIEW;
            }
            if (string.equals("perspective")) {
                return PERSPECTIVE;
            }
            return null;
        }
    }
}

