/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.jboss.forge.addon.ui.UIRuntime;
import org.jboss.forge.addon.ui.command.CommandFactory;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.CommandControllerFactory;
import org.jboss.forge.addon.ui.controller.WizardCommandController;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.context.UIContextImpl;
import org.jboss.tools.forge.ui.internal.ext.dialog.ForgeCommandDialog;
import org.jboss.tools.forge.ui.internal.ext.dialog.ForgeWizardDialog;
import org.jboss.tools.forge.ui.internal.ext.provider.ForgeUIProvider;
import org.jboss.tools.forge.ui.internal.ext.provider.ForgeUIRuntime;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizard;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;
import org.jboss.tools.forge.ui.notifications.NotificationType;

public final class WizardDialogHelper {
    private final UIContextImpl context;
    private final Shell parentShell;

    public WizardDialogHelper(Shell parentShell, IStructuredSelection selection) {
        this.parentShell = parentShell;
        ForgeUIProvider provider = new ForgeUIProvider();
        this.context = new UIContextImpl(provider, selection);
    }

    public UIContextImpl getContext() {
        return this.context;
    }

    public List<UICommand> getAllCandidatesAsList() {
        ArrayList<UICommand> result = new ArrayList<UICommand>();
        CommandFactory commandFactory = (CommandFactory)FurnaceService.INSTANCE.lookup(CommandFactory.class);
        for (UICommand uiCommand : commandFactory.getCommands()) {
            try {
                if (uiCommand instanceof UIWizardStep || !uiCommand.isEnabled((UIContext)this.context)) continue;
                result.add(uiCommand);
            }
            catch (Exception e) {
                ForgeUIPlugin.log(e);
            }
        }
        return result;
    }

    public UICommand getCommand(String name) {
        CommandFactory commandFactory = (CommandFactory)FurnaceService.INSTANCE.lookup(CommandFactory.class);
        return commandFactory.getCommandByName((UIContext)this.context, name);
    }

    public Map<String, UICommand> getAllCandidatesAsMap() {
        TreeMap<String, UICommand> result = new TreeMap<String, UICommand>();
        CommandFactory commandFactory = (CommandFactory)FurnaceService.INSTANCE.lookup(CommandFactory.class);
        for (UICommand uiCommand : commandFactory.getCommands()) {
            try {
                if (uiCommand instanceof UIWizardStep || !uiCommand.isEnabled((UIContext)this.context)) continue;
                UICommandMetadata metadata = uiCommand.getMetadata((UIContext)this.getContext());
                result.put(metadata.getName(), uiCommand);
            }
            catch (Exception e) {
                ForgeUIPlugin.log(e);
            }
        }
        return result;
    }

    public void openWizard(String windowTitle, UICommand selectedCommand) {
        this.openWizard(windowTitle, selectedCommand, null);
    }

    public void openWizard(String windowTitle, UICommand selectedCommand, Map<String, ?> values) {
        ForgeCommandDialog wizardDialog;
        CommandControllerFactory controllerFactory = (CommandControllerFactory)FurnaceService.INSTANCE.lookup(CommandControllerFactory.class);
        CommandFactory commandFactory = (CommandFactory)FurnaceService.INSTANCE.lookup(CommandFactory.class);
        selectedCommand = commandFactory.getNewCommandByName((UIContext)this.context, selectedCommand.getMetadata((UIContext)this.context).getName());
        if (windowTitle == null) {
            windowTitle = selectedCommand.getMetadata((UIContext)this.context).getName();
        }
        ForgeUIRuntime runtime = new ForgeUIRuntime();
        CommandController controller = controllerFactory.createController((UIContext)this.context, (UIRuntime)runtime, selectedCommand);
        try {
            controller.initialize();
        }
        catch (Exception e) {
            ForgeUIPlugin.displayMessage(windowTitle, "Error while initializing controller. Check logs", NotificationType.ERROR);
            ForgeUIPlugin.log(e);
            return;
        }
        ForgeWizard wizard = new ForgeWizard(windowTitle, controller, this.context);
        if (controller instanceof WizardCommandController) {
            WizardCommandController wizardController = (WizardCommandController)controller;
            if (values != null) {
                Object value;
                Map inputs = wizardController.getInputs();
                for (String key : inputs.keySet()) {
                    value = values.get(key);
                    if (value == null) continue;
                    wizardController.setValueFor(key, value);
                }
                while (wizardController.canMoveToNextStep()) {
                    try {
                        wizardController.next().initialize();
                    }
                    catch (Exception e) {
                        ForgeUIPlugin.log(e);
                        break;
                    }
                    inputs = wizardController.getInputs();
                    for (String key : inputs.keySet()) {
                        value = values.get(key);
                        if (value == null) continue;
                        wizardController.setValueFor(key, value);
                    }
                }
                while (wizardController.canMoveToPreviousStep()) {
                    try {
                        wizardController.previous();
                    }
                    catch (Exception e) {
                        ForgeUIPlugin.log(e);
                    }
                }
            }
            wizardDialog = new ForgeWizardDialog(this.parentShell, (IWizard)wizard, wizardController);
        } else {
            if (values != null) {
                for (Map.Entry<String, ?> entry : values.entrySet()) {
                    controller.setValueFor(entry.getKey(), entry.getValue());
                }
            }
            wizardDialog = new ForgeCommandDialog(this.parentShell, (IWizard)wizard);
        }
        wizardDialog.setHelpAvailable(false);
        wizardDialog.addPageChangingListener(new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent event) {
                ForgeWizardPage currentPage = (ForgeWizardPage)((Object)event.getCurrentPage());
                if (currentPage != null) {
                    currentPage.setChanged(false);
                }
            }
        });
        wizardDialog.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                wizardDialog.updateButtons();
            }
        });
        if (controller.getInputs().isEmpty() && controller.canExecute()) {
            try {
                ApplicationWindow window = new ApplicationWindow(this.parentShell);
                wizard.performFinish((IRunnableContext)window, this.parentShell);
            }
            catch (InterruptedException | InvocationTargetException e) {
                ForgeUIPlugin.log(e);
            }
        } else {
            try {
                wizardDialog.open();
            }
            catch (Exception e) {
                ForgeUIPlugin.displayMessage("Error", "Error while opening wizard. See Error log", NotificationType.ERROR);
                ForgeUIPlugin.log(e);
            }
        }
    }
}

