/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.tools.forge.core.furnace.FurnaceRuntime;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.dialog.WizardDialogHelper;
import org.jboss.tools.forge.ui.internal.ext.quickaccess.QuickAccessContents;
import org.jboss.tools.forge.ui.internal.ext.quickaccess.QuickAccessElement;
import org.jboss.tools.forge.ui.internal.ext.quickaccess.QuickAccessProvider;
import org.jboss.tools.forge.ui.internal.ext.quickaccess.impl.ForgeQuickAccessElement;
import org.jboss.tools.forge.ui.internal.ext.quickaccess.impl.ForgeQuickAccessProvider;
import org.jboss.tools.forge.ui.internal.part.ForgeConsoleView;
import org.jboss.tools.forge.ui.notifications.NotificationType;

public class UICommandListDialog
extends PopupDialog {
    private final WizardDialogHelper wizardHelper;
    private static final int MAXIMUM_NUMBER_OF_ELEMENTS = 5;
    private static final LinkedList<QuickAccessElement> PREVIOUS_CHOICES_LIST = new LinkedList();

    public UICommandListDialog(IWorkbenchWindow window) {
        super(window.getShell(), 16, true, true, false, true, true, "Run a Forge command", "JBoss Forge v." + FurnaceRuntime.INSTANCE.getVersion() + " - Start typing to filter the list");
        IStructuredSelection currentSelection = UICommandListDialog.getCurrentSelection(window);
        this.wizardHelper = new WizardDialogHelper(this.getParentShell(), currentSelection);
        UISelection uiSelection = this.wizardHelper.getContext().getInitialSelection();
        if (!uiSelection.isEmpty()) {
            IResource resource = uiSelection.getResource();
            String currentSelectionLabel = resource != null ? resource.getFullPath().toOSString() : uiSelection.get().toString();
            this.setTitleText("Current Selection: " + currentSelectionLabel);
        }
    }

    public static IStructuredSelection getCurrentSelection(IWorkbenchWindow window) {
        ISelectionService selectionService = window.getSelectionService();
        ISelection selection = selectionService.getSelection();
        TreeSelection currentSelection = null;
        if (selection instanceof TreeSelection) {
            currentSelection = (TreeSelection)selection;
        } else {
            Object activeEditorFile = UICommandListDialog.getActiveEditorInput(window);
            if (activeEditorFile != null) {
                currentSelection = new StructuredSelection(activeEditorFile);
            }
        }
        if (currentSelection == null) {
            currentSelection = (IStructuredSelection)selectionService.getSelection("org.eclipse.jdt.ui.PackageExplorer");
        }
        if (currentSelection == null) {
            currentSelection = (IStructuredSelection)selectionService.getSelection("org.eclipse.ui.navigator.ProjectExplorer");
        }
        if (currentSelection == null) {
            currentSelection = (IStructuredSelection)selectionService.getSelection("org.eclipse.ui.views.ResourceNavigator");
        }
        return currentSelection;
    }

    private static Object getActiveEditorInput(IWorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            IEditorPart editor = page.getActiveEditor();
            if (editor != null) {
                IEditorInput editorInput = editor.getEditorInput();
                if (editorInput != null) {
                    FileEditorInput fileEditorInput = (FileEditorInput)editorInput.getAdapter(FileEditorInput.class);
                    if (fileEditorInput != null) {
                        return fileEditorInput.getFile();
                    }
                    FileStoreEditorInput fileStoreEditorInput = (FileStoreEditorInput)editorInput.getAdapter(FileStoreEditorInput.class);
                    if (fileStoreEditorInput != null) {
                        return new File(fileStoreEditorInput.getURI());
                    }
                }
            } else {
                IWorkbenchPart part = page.getActivePart();
                if (part instanceof ForgeConsoleView) {
                    return ((ForgeConsoleView)part).getConsole().getCurrentResource();
                }
            }
        }
        return null;
    }

    protected Color getBackground() {
        return this.getShell().getDisplay().getSystemColor(1);
    }

    protected Color getForeground() {
        return this.getShell().getDisplay().getSystemColor(2);
    }

    protected Point getDefaultSize() {
        return new Point(640, 480);
    }

    protected Control createDialogArea(Composite parent) {
        final Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        result.setLayout((Layout)layout);
        final Text text = new Text(result, 640);
        text.setLayoutData((Object)new GridData(768));
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                QuickAccessProvider[] providers;
                try {
                    FurnaceService.INSTANCE.waitUntilContainerIsStarted();
                }
                catch (InterruptedException ie) {
                    ForgeUIPlugin.log(ie);
                    return;
                }
                try {
                    providers = UICommandListDialog.this.getProviders();
                }
                catch (Exception e) {
                    ForgeUIPlugin.log(e);
                    ForgeUIPlugin.displayMessage("Error has occurred. See Error Log for details", e.getMessage(), NotificationType.ERROR);
                    return;
                }
                QuickAccessContents quickAccessContents = new QuickAccessContents(providers){

                    @Override
                    public void updateFeedback(boolean filterTextEmpty, boolean showAllMatches) {
                    }

                    @Override
                    public void doClose() {
                        UICommandListDialog.this.close();
                    }

                    @Override
                    public QuickAccessElement getPerfectMatch(String filter) {
                        QuickAccessProvider[] quickAccessProviderArray = providers;
                        int n = providers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            QuickAccessProvider provider = quickAccessProviderArray[n2];
                            QuickAccessElement elem = provider.getElementForId(filter);
                            if (elem != null) {
                                return elem;
                            }
                            ++n2;
                        }
                        return null;
                    }

                    @Override
                    public void handleElementSelected(String textStr, Object selectedElement) {
                        if (selectedElement instanceof ForgeQuickAccessElement) {
                            ForgeQuickAccessElement element = (ForgeQuickAccessElement)selectedElement;
                            UICommandListDialog.this.addPreviousChoice(element);
                            UICommandListDialog.this.wizardHelper.openWizard(element.getLabel(), element.getCommand());
                        }
                    }
                };
                quickAccessContents.hookFilterText(text);
                quickAccessContents.createTable(result, Window.getDefaultOrientation());
                quickAccessContents.toggleShowAllMatches();
                text.setFocus();
            }
        });
        return result;
    }

    private QuickAccessProvider[] getProviders() {
        ArrayList<PreviousChoicesProvider> allProviders = new ArrayList<PreviousChoicesProvider>();
        HashSet<QuickAccessElement> allElements = new HashSet<QuickAccessElement>();
        TreeMap<String, ArrayList<UICommand>> categories = new TreeMap<String, ArrayList<UICommand>>();
        for (UICommand command : this.wizardHelper.getAllCandidatesAsList()) {
            String categoryName = this.getCategoryName((UIContext)this.wizardHelper.getContext(), command);
            ArrayList<UICommand> list = (ArrayList<UICommand>)categories.get(categoryName);
            if (list == null) {
                list = new ArrayList<UICommand>();
                categories.put(categoryName, list);
            }
            list.add(command);
        }
        TreeSet<ForgeQuickAccessProvider> providers = new TreeSet<ForgeQuickAccessProvider>();
        for (Map.Entry entry : categories.entrySet()) {
            ForgeQuickAccessProvider provider = new ForgeQuickAccessProvider((String)entry.getKey(), (UIContext)this.wizardHelper.getContext(), (List)entry.getValue(), PREVIOUS_CHOICES_LIST, allElements);
            providers.add(provider);
        }
        PREVIOUS_CHOICES_LIST.retainAll(allElements);
        allProviders.add(new PreviousChoicesProvider());
        allProviders.addAll(providers);
        return allProviders.toArray(new QuickAccessProvider[allProviders.size()]);
    }

    private String getCategoryName(UIContext context, UICommand command) {
        UICategory category = command.getMetadata(context).getCategory();
        if (category == null) {
            category = Categories.createDefault();
        }
        return category.toString();
    }

    private void addPreviousChoice(QuickAccessElement element) {
        PREVIOUS_CHOICES_LIST.remove(element);
        if (PREVIOUS_CHOICES_LIST.size() == 5) {
            PREVIOUS_CHOICES_LIST.removeLast();
        }
        PREVIOUS_CHOICES_LIST.addFirst(element);
    }

    private class PreviousChoicesProvider
    extends QuickAccessProvider {
        private PreviousChoicesProvider() {
        }

        @Override
        public String getId() {
            return "org.jboss.tools.forge.ui.previousChoices";
        }

        @Override
        public String getName() {
            return "Previous Choices";
        }

        @Override
        public ImageDescriptor getImageDescriptor() {
            return ForgeUIPlugin.getForgeIcon();
        }

        @Override
        public List<QuickAccessElement> getElements() {
            return PREVIOUS_CHOICES_LIST;
        }

        @Override
        public List<QuickAccessElement> getElementsSorted() {
            return PREVIOUS_CHOICES_LIST;
        }

        @Override
        public QuickAccessElement getElementForId(String id) {
            return null;
        }

        @Override
        protected void doReset() {
        }
    }
}

