/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.control;

import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.control.AbstractTextButtonControl;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;

public class JavaPackageChooserControlBuilder
extends AbstractTextButtonControl {
    @Override
    protected void decorateContainerText(ForgeWizardPage page, InputComponent<?, ?> input, Text containerText) {
        if (InputComponents.getCompleterFor(input) != null) {
            return;
        }
        final IJavaProject selectedProject = this.getSelectedProject(page);
        if (selectedProject != null) {
            UICompleter<Object> completer = new UICompleter<Object>(){

                public Iterable<Object> getCompletionProposals(UIContext context, InputComponent<?, Object> input, String value) {
                    TreeSet<Object> proposals = new TreeSet<Object>();
                    try {
                        IPackageFragment[] iPackageFragmentArray = selectedProject.getPackageFragments();
                        int n = iPackageFragmentArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String name;
                            IPackageFragment pkg = iPackageFragmentArray[n2];
                            if (pkg.getKind() != 2 && (name = pkg.getElementName()).startsWith(value)) {
                                proposals.add(name);
                            }
                            ++n2;
                        }
                    }
                    catch (JavaModelException jme) {
                        ForgeUIPlugin.log(jme);
                    }
                    return proposals;
                }
            };
            this.setupAutoCompleteForText(page.getWizard().getUIContext(), input, completer, containerText);
        }
    }

    @Override
    protected void browseButtonPressed(ForgeWizardPage page, InputComponent<?, ?> input, Text containerText) {
        IJavaProject project = this.getSelectedProject(page);
        if (project == null) {
            MessageDialog.openError((Shell)page.getShell(), (String)"No project selected", (String)"No project was selected");
            return;
        }
        int style = 32;
        try {
            SelectionDialog dialog = JavaUI.createPackageDialog((Shell)page.getShell(), (IJavaProject)project, (int)style, (String)containerText.getText());
            dialog.setTitle("Package Selection");
            dialog.setMessage("Select a package.");
            if (dialog.open() == 0) {
                IPackageFragment res = (IPackageFragment)dialog.getResult()[0];
                containerText.setText(res.getElementName());
            }
        }
        catch (JavaModelException ex) {
            ForgeUIPlugin.log(ex);
        }
    }

    private IJavaProject getSelectedProject(ForgeWizardPage page) {
        IResource resource;
        UISelection initialSelection = page.getWizard().getUIContext().getInitialSelection();
        IJavaProject project = initialSelection != null ? ((resource = initialSelection.getResource()) != null ? JavaCore.create((IProject)resource.getProject()) : null) : null;
        return project;
    }

    @Override
    protected Class<String> getProducedType() {
        return String.class;
    }

    @Override
    protected String getSupportedInputType() {
        return "org.jboss.forge.inputType.JAVA_PACKAGE_PICKER";
    }

    @Override
    protected Class<?>[] getSupportedInputComponentTypes() {
        return new Class[]{UIInput.class};
    }
}

