/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.commands.ForgeCommandPostProcessor;

public class RmPostProcessor
implements ForgeCommandPostProcessor {
    private ArrayList<String> getResourcesToDelete(Map<String, String> commandDetails) {
        String crn = commandDetails.get("crn");
        String par = commandDetails.get("par");
        int start = par.lastIndexOf(91);
        int end = par.lastIndexOf(93);
        if (start == -1 || end == -1) {
            return null;
        }
        par = par.substring(start + 1, end);
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(par);
        while (tokenizer.hasMoreTokens()) {
            result.add(String.valueOf(crn) + File.separator + tokenizer.nextToken());
        }
        return result;
    }

    @Override
    public void postProcess(Map<String, String> commandDetails) {
        ArrayList<String> resourceNames = this.getResourcesToDelete(commandDetails);
        if (resourceNames == null) {
            return;
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (String resourceName : resourceNames) {
            if (resourceName.endsWith("/")) {
                resourceName = resourceName.substring(0, resourceName.length() - 1);
            }
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.exists() && resourceName.equals(project.getLocation().toOSString())) {
                    try {
                        project.delete(false, false, null);
                    }
                    catch (CoreException e) {
                        ForgeUIPlugin.log(e);
                    }
                }
                ++n2;
            }
        }
    }
}

