/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.commands;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.jboss.tools.forge.core.preferences.ForgeCorePreferences;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeState;
import org.jboss.tools.forge.core.util.ProjectTools;
import org.jboss.tools.forge.ui.internal.commands.ForgeCommandPostProcessor;

public class NewProjectPostProcessor
implements ForgeCommandPostProcessor {
    private String makePlatformIndependent(String path) {
        int index;
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        return (index = path.indexOf(47)) != -1 ? path.substring(index) : path;
    }

    @Override
    public void postProcess(Map<String, String> commandDetails) {
        String projectPath = this.makePlatformIndependent(commandDetails.get("cpn"));
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String workspacePath = this.makePlatformIndependent(workspaceRoot.getLocation().toString());
        if (workspacePath.equals(projectPath)) {
            if (MessageDialog.open((int)3, null, (String)"Project Import Failed", (String)"The Forge runtime created the project in the workspace root. Such a project cannot be imported.\nDo you want to remove the created artifacts?", (int)0)) {
                String srcPath;
                File srcDir;
                String fileSeparator = System.getProperty("file.separator");
                String pomPath = String.valueOf(projectPath) + fileSeparator + "pom.xml";
                File pomFile = new File(pomPath);
                if (pomFile.exists()) {
                    this.delete(pomFile);
                }
                if ((srcDir = new File(srcPath = String.valueOf(projectPath) + fileSeparator + "src")).exists()) {
                    this.delete(srcDir);
                }
                this.resetRuntime();
            }
        } else {
            int index = projectPath.lastIndexOf(47);
            if (index != -1) {
                String projectDirName = projectPath.substring(index + 1);
                String projectBaseDirPath = projectPath.substring(0, index);
                ProjectTools.importProject((String)projectBaseDirPath, (String)projectDirName);
            }
        }
    }

    private void delete(File f) {
        if (f.isDirectory()) {
            String[] stringArray = f.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.delete(new File(f, s));
                ++n2;
            }
        }
        f.delete();
    }

    private void resetRuntime() {
        ForgeRuntime runtime = ForgeCorePreferences.INSTANCE.getDefaultRuntime();
        if (runtime != null && ForgeRuntimeState.RUNNING.equals((Object)runtime.getState())) {
            runtime.sendInput("reset\n");
        }
    }
}

