/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.wizards;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.arquillian.ui.internal.wizards.ProjectResource;

public class ResourceEditingSupport
extends EditingSupport {
    private CellEditor editor;
    private int column;

    public ResourceEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        switch (column) {
            case 0: {
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            case 1: {
                this.editor = new CheckboxCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            default: {
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
            }
        }
        this.column = column;
    }

    protected boolean canEdit(Object element) {
        return this.column != 0;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected Object getValue(Object element) {
        ProjectResource resourceDeployment = (ProjectResource)element;
        String value = null;
        switch (this.column) {
            case 0: {
                value = resourceDeployment.getPath().toString();
                if (value == null) {
                    value = "";
                }
                return value;
            }
            case 1: {
                return resourceDeployment.isDeployAsWebInfResource();
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        ProjectResource resourceDeployment = (ProjectResource)element;
        switch (this.column) {
            case 0: {
                if (value != null) {
                    resourceDeployment.setPath((IPath)new Path(value.toString()));
                } else {
                    resourceDeployment.setPath(null);
                }
                ISelection selection = this.getViewer().getSelection();
                this.getViewer().setSelection(null);
                this.getViewer().setSelection(selection);
                break;
            }
            case 1: {
                resourceDeployment.setDeployAsWebInfResource((Boolean)value);
                break;
            }
        }
        this.getViewer().update(element, null);
    }
}

