/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.jboss.tools.arquillian.core.internal.util.ArquillianSearchEngine;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.commands.AddArquillianCommandHandler;
import org.jboss.tools.arquillian.ui.internal.wizards.ArquillianWizard;
import org.jboss.tools.arquillian.ui.internal.wizards.NewArquillianJUnitTestCaseDeploymentPage;
import org.jboss.tools.arquillian.ui.internal.wizards.NewArquillianJUnitTestCasePageOne;
import org.jboss.tools.arquillian.ui.internal.wizards.NewArquillianJUnitTestCasePageTwo;

public class NewArquillianJUnitTestWizard
extends ArquillianWizard {
    public static final String JUNIT4_ANNOTATION_NAME = "org.junit.Test";
    private NewArquillianJUnitTestCasePageOne newArquillianJUnitTestCasePageOne;
    private NewArquillianJUnitTestCasePageTwo newArquillianJUnitTestCasePageTwo;
    private NewArquillianJUnitTestCaseDeploymentPage newArquillianJUnitTestCaseDeploymentPage;

    public NewArquillianJUnitTestWizard() {
        this.setWindowTitle("New Arquillian JUnit Test Case");
        this.initDialogSettings();
    }

    @Override
    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(ArquillianUIActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.arquillian.ui", (String)"icons/arquillian_icon64.png"));
    }

    public void addPages() {
        super.addPages();
        this.newArquillianJUnitTestCasePageTwo = new NewArquillianJUnitTestCasePageTwo();
        this.newArquillianJUnitTestCaseDeploymentPage = new NewArquillianJUnitTestCaseDeploymentPage();
        this.newArquillianJUnitTestCasePageOne = new NewArquillianJUnitTestCasePageOne(this.newArquillianJUnitTestCasePageTwo, this.newArquillianJUnitTestCaseDeploymentPage);
        this.addPage((IWizardPage)this.newArquillianJUnitTestCasePageOne);
        this.newArquillianJUnitTestCasePageOne.init(this.getSelection());
        this.addPage((IWizardPage)this.newArquillianJUnitTestCasePageTwo);
        this.addPage((IWizardPage)this.newArquillianJUnitTestCaseDeploymentPage);
    }

    @Override
    public boolean performFinish() {
        IJavaProject project = this.newArquillianJUnitTestCasePageOne.getJavaProject();
        IRunnableWithProgress runnable = this.newArquillianJUnitTestCasePageOne.getRunnable();
        try {
            if (!ArquillianSearchEngine.hasArquillianType((IJavaProject)project)) {
                runnable = this.addArquillianToClasspath(project, runnable);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        if (this.finishPage(runnable)) {
            IType newClass = this.newArquillianJUnitTestCasePageOne.getCreatedType();
            IResource resource = newClass.getCompilationUnit().getResource();
            if (resource != null) {
                this.selectAndReveal(resource);
                this.openResource(resource);
            }
            return true;
        }
        return false;
    }

    private IRunnableWithProgress addArquillianToClasspath(IJavaProject project, final IRunnableWithProgress runnable) {
        ClasspathFixProcessor.ClasspathFixProposal[] fixProposals = new ArquillianClasspathFixProposal[]{new ArquillianClasspathFixProposal(project, 15)};
        ClasspathFixSelectionDialog dialog = new ClasspathFixSelectionDialog(this.getShell(), project, fixProposals);
        if (dialog.open() != 0) {
            throw new OperationCanceledException();
        }
        final ClasspathFixProcessor.ClasspathFixProposal fix = dialog.getSelectedClasspathFix();
        if (fix != null) {
            return new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("Create Arquillian JUnit test case", 4);
                    try {
                        try {
                            Change change = fix.createChange((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            new PerformChangeOperation(change).run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            runnable.run((IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
        }
        return runnable;
    }

    public NewArquillianJUnitTestCasePageOne getNewArquillianJUnitTestCasePageOne() {
        return this.newArquillianJUnitTestCasePageOne;
    }

    public NewArquillianJUnitTestCasePageTwo getNewArquillianJUnitTestCasePageTwo() {
        return this.newArquillianJUnitTestCasePageTwo;
    }

    public NewArquillianJUnitTestCaseDeploymentPage getNewArquillianJUnitTestCaseDeploymentPage() {
        return this.newArquillianJUnitTestCaseDeploymentPage;
    }

    private static class ArquillianClasspathFixProposal
    extends ClasspathFixProcessor.ClasspathFixProposal {
        private final int fRelevance;
        private final IJavaProject fProject;

        public ArquillianClasspathFixProposal(IJavaProject project, int relevance) {
            this.fProject = project;
            this.fRelevance = relevance;
        }

        public String getAdditionalProposalInfo() {
            return "Add Arquillian Support";
        }

        public Change createChange(IProgressMonitor monitor) throws CoreException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            new AddArquillianCommandHandler().execute(this.fProject.getProject());
            return new NullChange();
        }

        public String getDisplayString() {
            return "Add Arquillian Support";
        }

        public Image getImage() {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
        }

        public int getRelevance() {
            return this.fRelevance;
        }
    }

    private static class ClasspathFixSelectionDialog
    extends MessageDialog
    implements SelectionListener,
    IDoubleClickListener {
        private final ClasspathFixProcessor.ClasspathFixProposal[] fFixProposals;
        private final IJavaProject fProject;
        private TableViewer fFixSelectionTable;
        private Button fNoActionRadio;
        private Button fOpenBuildPathRadio;
        private Button fPerformFix;
        private ClasspathFixProcessor.ClasspathFixProposal fSelectedFix;
        private static final String BUILD_PATH_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
        private static final String BUILD_PATH_BLOCK = "block_until_buildpath_applied";

        public ClasspathFixSelectionDialog(Shell parent, IJavaProject project, ClasspathFixProcessor.ClasspathFixProposal[] fixProposals) {
            super(parent, "New Arquillian JUnit test case", null, ClasspathFixSelectionDialog.getDialogMessage(), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.fProject = project;
            this.fFixProposals = fixProposals;
            this.fSelectedFix = null;
        }

        protected boolean isResizable() {
            return true;
        }

        private static String getDialogMessage() {
            return "Arquillian JUnit is not on the build path. Do you want to add it?";
        }

        protected Control createCustomArea(Composite composite) {
            this.fNoActionRadio = new Button(composite, 16);
            this.fNoActionRadio.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fNoActionRadio.setText("&Not now");
            this.fNoActionRadio.addSelectionListener((SelectionListener)this);
            this.fOpenBuildPathRadio = new Button(composite, 16);
            this.fOpenBuildPathRadio.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fOpenBuildPathRadio.setText("&Open the build path property page");
            this.fOpenBuildPathRadio.addSelectionListener((SelectionListener)this);
            if (this.fFixProposals.length > 0) {
                this.fPerformFix = new Button(composite, 16);
                this.fPerformFix.setLayoutData((Object)new GridData(16384, 128, false, false));
                this.fPerformFix.setText("&Perform the following action:");
                this.fPerformFix.addSelectionListener((SelectionListener)this);
                this.fFixSelectionTable = new TableViewer(composite, 2052);
                this.fFixSelectionTable.setContentProvider((IContentProvider)new ArrayContentProvider());
                this.fFixSelectionTable.setLabelProvider((IBaseLabelProvider)new ClasspathFixLabelProvider());
                this.fFixSelectionTable.setComparator(new ViewerComparator());
                this.fFixSelectionTable.addDoubleClickListener((IDoubleClickListener)this);
                this.fFixSelectionTable.setInput((Object)this.fFixProposals);
                this.fFixSelectionTable.setSelection((ISelection)new StructuredSelection((Object)this.fFixProposals[0]));
                GridData gridData = new GridData(4, 4, true, true);
                gridData.heightHint = this.convertHeightInCharsToPixels(4);
                gridData.horizontalIndent = this.convertWidthInCharsToPixels(2);
                this.fFixSelectionTable.getControl().setLayoutData((Object)gridData);
                this.fNoActionRadio.setSelection(false);
                this.fOpenBuildPathRadio.setSelection(false);
                this.fPerformFix.setSelection(true);
            } else {
                this.fNoActionRadio.setSelection(true);
                this.fOpenBuildPathRadio.setSelection(false);
            }
            this.updateEnableStates();
            return composite;
        }

        private void updateEnableStates() {
            if (this.fPerformFix != null) {
                this.fFixSelectionTable.getTable().setEnabled(this.fPerformFix.getSelection());
            }
        }

        protected void buttonPressed(int buttonId) {
            this.fSelectedFix = null;
            if (buttonId == 0 && !this.fNoActionRadio.getSelection()) {
                IStructuredSelection selection;
                Object firstElement;
                if (this.fOpenBuildPathRadio.getSelection()) {
                    String id = BUILD_PATH_PAGE_ID;
                    HashMap<String, Boolean> input = new HashMap<String, Boolean>();
                    input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
                    if (PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fProject, (String)id, (String[])new String[]{id}, input).open() != 0) {
                        return;
                    }
                } else if (this.fFixSelectionTable != null && (firstElement = (selection = (IStructuredSelection)this.fFixSelectionTable.getSelection()).getFirstElement()) instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    this.fSelectedFix = (ClasspathFixProcessor.ClasspathFixProposal)firstElement;
                }
            }
            super.buttonPressed(buttonId);
        }

        public ClasspathFixProcessor.ClasspathFixProposal getSelectedClasspathFix() {
            return this.fSelectedFix;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.updateEnableStates();
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateEnableStates();
        }

        public void doubleClick(DoubleClickEvent event) {
            this.okPressed();
        }

        static class ClasspathFixLabelProvider
        extends LabelProvider {
            ClasspathFixLabelProvider() {
            }

            public Image getImage(Object element) {
                if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                    return classpathFixProposal.getImage();
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                    return classpathFixProposal.getDisplayString();
                }
                return null;
            }
        }
    }
}

