/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.launcher;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.m2e.profiles.ui.internal.actions.ProfileSelectionHandler;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.commands.AddArquillianProfilesCommandHandler;
import org.jboss.tools.arquillian.ui.internal.launcher.ArquillianLaunchConfigurationTab;
import org.jboss.tools.arquillian.ui.internal.launcher.ArquillianProperty;
import org.jboss.tools.arquillian.ui.internal.launcher.AutoResizeTableLayout;
import org.jboss.tools.arquillian.ui.internal.utils.ArquillianUIUtil;
import org.osgi.framework.Bundle;

public class ArquillianTab
extends AbstractLaunchConfigurationTab {
    private static final String MANAGEMENT_ADDRESS = "managementAddress";
    private static final String MANAGEMENT_PORT = "managementPort";
    private static final String RUN_MODE = "run";
    private static final String DEBUG_MODE = "debug";
    public static final String ID = "org.jboss.tools.arquillian.ui.arquillianTab";
    private Image checkboxOn;
    private Image checkboxOff;
    private Set<ArquillianProperty> properties;
    private TableViewer propertiesViewer;
    private TableViewer serversViewer;
    private Button saveButton;
    private ILaunchConfiguration configuration;
    private Button selectProfilesButton;
    private Button addProfilesButton;
    private Image image;
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (ArquillianTab.this.configuration == null) {
                return;
            }
            String name = null;
            try {
                name = ArquillianUtility.getJavaProject((ILaunchConfiguration)ArquillianTab.this.configuration).getElementName();
            }
            catch (CoreException coreException) {}
            if (name == null) {
                return;
            }
            if (event.getType() == 16) {
                IResourceDelta delta = event.getDelta();
                IResourceDelta projectDelta = delta.findMember((IPath)new Path(name));
                if (projectDelta == null) {
                    return;
                }
                IResource project = projectDelta.getResource();
                if (project != null && project instanceof IProject) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ILaunchConfigurationTab[] tabs;
                            if (ArquillianTab.this.propertiesViewer == null || ArquillianTab.this.propertiesViewer.getControl() == null) {
                                return;
                            }
                            if (ArquillianTab.this.propertiesViewer.getControl().isDisposed()) {
                                ArquillianTab.this.dispose();
                                return;
                            }
                            ArquillianTab.this.properties = null;
                            ArquillianTab.this.initializeFrom(ArquillianTab.this.configuration);
                            ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = ArquillianTab.this.getLaunchConfigurationDialog().getTabs();
                            int n = tabs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
                                if (tab instanceof ArquillianLaunchConfigurationTab) {
                                    ((ArquillianLaunchConfigurationTab)tab).validatePage();
                                    break;
                                }
                                ++n2;
                            }
                            ArquillianTab.this.getLaunchConfigurationDialog().updateButtons();
                            ArquillianTab.this.getLaunchConfigurationDialog().updateMessage();
                        }
                    });
                }
            }
        }
    };
    private IServer[] servers;
    private IServerListener serverListener = new IServerListener(){

        public void serverChanged(ServerEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ArquillianTab.this.serversViewer != null && !ArquillianTab.this.serversViewer.getControl().isDisposed()) {
                        ArquillianTab.this.serversViewer.refresh();
                        ArquillianTab.this.updateServerButtons();
                    }
                }
            });
        }
    };
    private Button startButton;
    private Button debugButton;
    private Button stopButton;
    private Button testButton;

    public ArquillianTab() {
        this.image = ArquillianUIActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.arquillian.ui", (String)"icons/arquillian_icon16.png").createImage();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        Dialog.applyDialogFont((Control)composite);
        Group propertiesGroup = new Group(composite, 0);
        propertiesGroup.setLayout((Layout)new GridLayout(1, false));
        propertiesGroup.setText("Configuration properties");
        gd = new GridData(4, 4, true, false);
        propertiesGroup.setLayoutData((Object)gd);
        this.propertiesViewer = this.createPropertiesSection((Composite)propertiesGroup);
        Composite propertiesButtonComposite = new Composite(composite, 0);
        gd = new GridData(131072, 4, true, false);
        propertiesButtonComposite.setLayoutData((Object)gd);
        propertiesButtonComposite.setLayout((Layout)new GridLayout(4, false));
        this.testButton = this.createButton(propertiesButtonComposite, "Test Management");
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ArquillianTab.this.properties == null) {
                    return;
                }
                final String[] managementAddress = new String[1];
                final String[] managementPort = new String[1];
                for (ArquillianProperty property : ArquillianTab.this.properties) {
                    String name = ArquillianTab.this.getPropertyName(property);
                    if (ArquillianTab.MANAGEMENT_PORT.equals(name)) {
                        managementPort[0] = property.getValue();
                    }
                    if (!ArquillianTab.MANAGEMENT_ADDRESS.equals(name)) continue;
                    managementAddress[0] = property.getValue();
                }
                if (managementAddress[0] != null && managementPort[0] != null && !managementAddress[0].isEmpty() && !managementPort[0].isEmpty()) {
                    BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void run() {
                            Socket socket = null;
                            InetAddress addr = InetAddress.getByName(managementAddress[0]);
                            int port = 0;
                            try {
                                port = Integer.valueOf(managementPort[0]);
                            }
                            catch (NumberFormatException e1) {
                                ArquillianUIActivator.log(e1);
                                if (socket == null) return;
                                try {
                                    socket.close();
                                    return;
                                }
                                catch (IOException iOException) {}
                                return;
                            }
                            try {
                                try {
                                    InetSocketAddress sockaddr = new InetSocketAddress(addr, port);
                                    socket = new Socket();
                                    socket.connect(sockaddr, 15000);
                                    MessageDialog.openInformation((Shell)ArquillianTab.this.getShell(), (String)"Test Management", (String)"Test succeeded");
                                }
                                catch (Exception e1) {
                                    MessageDialog.openInformation((Shell)ArquillianTab.this.getShell(), (String)"Test Management", (String)("Test failed.\n" + e1.getLocalizedMessage()));
                                    if (socket == null) return;
                                    try {
                                        socket.close();
                                        return;
                                    }
                                    catch (IOException iOException) {}
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                if (socket == null) throw throwable;
                                try {
                                    socket.close();
                                    throw throwable;
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            if (socket == null) return;
                            try {
                                socket.close();
                                return;
                            }
                            catch (IOException iOException) {}
                        }
                    });
                }
            }
        });
        this.addProfilesButton = this.createButton(propertiesButtonComposite, "Add Arquillian Profiles");
        this.addProfilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject project = ArquillianTab.this.getProject();
                new AddArquillianProfilesCommandHandler().execute(project);
            }
        });
        this.addProfilesButton.setEnabled(this.isArquillianProject(this.configuration));
        if (this.mavenProfileExists()) {
            this.selectProfilesButton = this.createButton(propertiesButtonComposite, "Select Maven Profiles");
            this.selectProfilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IProject project = ArquillianTab.this.getProject();
                    try {
                        new ProfileSelectionHandler().execute(ArquillianTab.this.getShell(), new IProject[]{project});
                    }
                    catch (ExecutionException e1) {
                        ArquillianUIActivator.log(e1);
                    }
                }
            });
            this.selectProfilesButton.setEnabled(this.isArquillianProject(this.configuration));
        } else {
            new Label(propertiesButtonComposite, 0);
        }
        this.saveButton = this.createButton(propertiesButtonComposite, "Save");
        this.saveButton.setEnabled(false);
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ArquillianUIUtil.save(ArquillianTab.this.properties, ArquillianTab.this.configuration);
                    ArquillianTab.this.saveButton.setEnabled(false);
                }
                catch (CoreException e1) {
                    MessageDialog.openConfirm((Shell)ArquillianTab.this.getShell(), (String)"Error", (String)e1.getMessage());
                }
            }
        });
        Group serversGroup = new Group(composite, 0);
        serversGroup.setLayout((Layout)new GridLayout(1, false));
        serversGroup.setText("Servers");
        gd = new GridData(4, 4, true, false);
        serversGroup.setLayoutData((Object)gd);
        this.serversViewer = this.createServersSection((Composite)serversGroup);
        Composite serversButtonComposite = new Composite(composite, 0);
        gd = new GridData(131072, 4, true, false);
        serversButtonComposite.setLayoutData((Object)gd);
        serversButtonComposite.setLayout((Layout)new GridLayout(3, false));
        this.startButton = this.createButton(serversButtonComposite, "Start");
        this.startButton.setEnabled(false);
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final IServer server = ArquillianTab.this.getSelectedServer();
                if (server == null) {
                    return;
                }
                Job job = new Job("Starting ..."){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            server.start(ArquillianTab.RUN_MODE, monitor);
                        }
                        catch (CoreException coreException) {
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        });
        this.debugButton = this.createButton(serversButtonComposite, "Debug");
        this.debugButton.setEnabled(false);
        this.debugButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final IServer server = ArquillianTab.this.getSelectedServer();
                if (server == null) {
                    return;
                }
                Job job = new Job("Starting ..."){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            server.start(ArquillianTab.DEBUG_MODE, monitor);
                        }
                        catch (CoreException coreException) {
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        });
        this.stopButton = this.createButton(serversButtonComposite, "Stop");
        this.stopButton.setEnabled(false);
        this.stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final IServer server = ArquillianTab.this.getSelectedServer();
                if (server == null) {
                    return;
                }
                Job job = new Job("Starting ..."){

                    protected IStatus run(IProgressMonitor monitor) {
                        server.stop(false);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        });
        this.serversViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArquillianTab.this.updateServerButtons();
            }
        });
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 16);
    }

    private boolean isArquillianProject(ILaunchConfiguration conf) {
        try {
            IJavaProject javaProject = ArquillianUtility.getJavaProject((ILaunchConfiguration)conf);
            return javaProject != null && javaProject.getProject() != null && javaProject.getProject().isAccessible() && javaProject.getProject().hasNature("org.jboss.tools.arquillian.core.arquillianNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean mavenProfileExists() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.m2e.profiles.ui");
        return bundle != null;
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData gd = new GridData(131072, 4, false, false);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        gd.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)gd);
        return button;
    }

    private int convertHorizontalDLUsToPixels(int dlus) {
        GC gc = new GC((Drawable)this.getControl());
        gc.setFont(this.getControl().getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return (fontMetrics.getAverageCharWidth() * dlus + 2) / 4;
    }

    private TableViewer createServersSection(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 68356);
        GridData gd = new GridData(1808);
        gd.heightHint = 80;
        viewer.getTable().setLayoutData((Object)gd);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        viewer.setContentProvider((IContentProvider)new ServersContentProvider());
        String[] columnHeaders = new String[]{"Name", "Runtime", "Home", "Mode"};
        int i = 0;
        while (i < columnHeaders.length) {
            TableViewerColumn column = new TableViewerColumn(viewer, 0);
            column.setLabelProvider((CellLabelProvider)new ServersLabelProvider(i));
            column.getColumn().setText(columnHeaders[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            ++i;
        }
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(80, 80), new ColumnWeightData(60, 60), new ColumnWeightData(140, 140), new ColumnWeightData(40, 40)};
        AutoResizeTableLayout layout = new AutoResizeTableLayout(table);
        int i2 = 0;
        while (i2 < layouts.length) {
            layout.addColumnData(layouts[i2]);
            ++i2;
        }
        viewer.getTable().setLayout((Layout)layout);
        viewer.setInput((Object)this.getServers());
        return viewer;
    }

    private IServer[] getServers() {
        this.removeServerListeners();
        this.servers = ServerCore.getServers();
        ArrayList<IServer> l = new ArrayList<IServer>();
        IServer[] iServerArray = this.servers;
        int n = this.servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server != null && server.getRuntime() != null && server.getRuntime().getLocation() != null) {
                l.add(server);
            }
            ++n2;
        }
        this.addServerListeners();
        return l.toArray(new IServer[0]);
    }

    private void addServerListeners() {
        if (this.servers != null) {
            IServer[] iServerArray = this.servers;
            int n = this.servers.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                server.addServerListener(this.serverListener);
                ++n2;
            }
        }
    }

    private void removeServerListeners() {
        if (this.servers != null) {
            IServer[] iServerArray = this.servers;
            int n = this.servers.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                server.removeServerListener(this.serverListener);
                ++n2;
            }
        }
    }

    private TableViewer createPropertiesSection(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 68356);
        GridData gd = new GridData(1808);
        gd.heightHint = 90;
        viewer.getTable().setLayoutData((Object)gd);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        viewer.setContentProvider((IContentProvider)new PropertiesContentProvider());
        String[] columnHeaders = new String[]{"Name", "Value", "Source", "Default?"};
        int i = 0;
        while (i < columnHeaders.length) {
            TableViewerColumn column = new TableViewerColumn(viewer, 0);
            column.setLabelProvider((CellLabelProvider)new PropertiesLabelProvider(i));
            column.getColumn().setText(columnHeaders[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            column.setEditingSupport((EditingSupport)new ArquillianPropertiesEditingSupport((ColumnViewer)viewer, i));
            ++i;
        }
        ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnWeightData(150, 150), new ColumnWeightData(120, 120), new ColumnWeightData(60, 60), new ColumnWeightData(30, 30)};
        AutoResizeTableLayout layout = new AutoResizeTableLayout(table);
        int i2 = 0;
        while (i2 < layouts.length) {
            layout.addColumnData(layouts[i2]);
            ++i2;
        }
        viewer.getTable().setLayout((Layout)layout);
        this.configureViewer(viewer);
        viewer.setInput(this.properties);
        return viewer;
    }

    private void configureViewer(final TableViewer viewer) {
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = viewer.getColumnViewerEditor().getFocusCell();
                if (cell != null && cell.getColumnIndex() == 1) {
                    return super.isEditorActivationEvent(event);
                }
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.properties = null;
        this.initializeFrom((ILaunchConfiguration)configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.propertiesViewer != null && this.propertiesViewer.getControl() != null && !this.propertiesViewer.getControl().isDisposed() && this.isArquillianProject(configuration)) {
            this.properties = ArquillianUIUtil.getArquillianProperties(configuration);
            this.propertiesViewer.setInput(this.properties);
            this.propertiesViewer.refresh();
            this.updatePropertiesButton();
        }
        this.configuration = configuration;
        this.updateButton(this.addProfilesButton);
        this.updateButton(this.selectProfilesButton);
        this.updateButton(this.testButton);
    }

    private void updateButton(Button button) {
        if (button != null && !button.isDisposed()) {
            button.setEnabled(this.isArquillianProject(this.configuration));
        }
    }

    private void updatePropertiesButton() {
        if (this.properties == null) {
            this.testButton.setEnabled(false);
        }
        boolean hasManagementPort = false;
        boolean hasManagementAddress = false;
        for (ArquillianProperty property : this.properties) {
            String name = this.getPropertyName(property);
            if (MANAGEMENT_PORT.equals(name)) {
                hasManagementPort = true;
            }
            if (!MANAGEMENT_ADDRESS.equals(name)) continue;
            hasManagementAddress = true;
        }
        this.testButton.setEnabled(hasManagementAddress && hasManagementPort);
    }

    private String getPropertyName(ArquillianProperty property) {
        if (property == null) {
            return null;
        }
        String name = property.getName();
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(".");
        if (index > 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
    }

    public String getName() {
        return "Arquillian";
    }

    public String getId() {
        return ID;
    }

    public Image getCheckOnImage() {
        if (this.checkboxOn == null) {
            this.checkboxOn = ArquillianUIActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.arquillian.ui", (String)"/icons/xpl/complete_tsk.gif").createImage();
        }
        return this.checkboxOn;
    }

    public Image getCheckOffImage() {
        if (this.checkboxOff == null) {
            this.checkboxOff = ArquillianUIActivator.imageDescriptorFromPlugin((String)"org.jboss.tools.arquillian.ui", (String)"/icons/xpl/incomplete_tsk.gif").createImage();
        }
        return this.checkboxOff;
    }

    public void dispose() {
        super.dispose();
        if (this.checkboxOn != null) {
            this.checkboxOn.dispose();
            this.checkboxOn = null;
        }
        if (this.checkboxOff != null) {
            this.checkboxOff.dispose();
            this.checkboxOff = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
        this.removeServerListeners();
    }

    private IServer getSelectedServer() {
        ISelection sel = this.serversViewer.getSelection();
        IServer server = null;
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            server = (IServer)selection.getFirstElement();
        }
        return server;
    }

    private void updateServerButtons() {
        this.startButton.setEnabled(false);
        this.debugButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        IServer server = this.getSelectedServer();
        if (server == null) {
            return;
        }
        int state = server.getServerState();
        switch (state) {
            case 4: {
                this.startButton.setEnabled(true);
                this.debugButton.setEnabled(true);
                break;
            }
            case 2: {
                this.stopButton.setEnabled(true);
                break;
            }
        }
    }

    public Image getImage() {
        return this.image;
    }

    private IProject getProject() {
        IProject project = null;
        try {
            IJavaProject javaProject = ArquillianUtility.getJavaProject((ILaunchConfiguration)this.configuration);
            if (javaProject != null) {
                project = javaProject.getProject();
            }
        }
        catch (CoreException e1) {
            ArquillianUIActivator.log(e1);
        }
        return project;
    }

    private class ArquillianPropertiesEditingSupport
    extends EditingSupport {
        private CellEditor editor;
        private int column;

        public ArquillianPropertiesEditingSupport(ColumnViewer viewer, int column) {
            super(viewer);
            switch (column) {
                case 3: {
                    this.editor = new CheckboxCellEditor((Composite)((TableViewer)viewer).getTable());
                    break;
                }
                default: {
                    this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                }
            }
            this.column = column;
        }

        protected boolean canEdit(Object element) {
            return this.column == 1;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            ArquillianProperty properties = (ArquillianProperty)element;
            String value = null;
            switch (this.column) {
                case 0: {
                    value = properties.getName();
                    if (value == null) {
                        value = "";
                    }
                    return value;
                }
                case 1: {
                    value = properties.getValue();
                    if (value == null) {
                        value = "";
                    }
                    return value;
                }
                case 2: {
                    value = properties.getSource();
                    if (value == null) {
                        value = "";
                    }
                    return value;
                }
                case 3: {
                    boolean isDefault = properties.isDefaultValue();
                    return isDefault;
                }
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            ArquillianProperty property = (ArquillianProperty)element;
            switch (this.column) {
                case 1: {
                    if (value != null) {
                        property.setValue(value.toString());
                    } else {
                        property.setValue(null);
                    }
                    property.setChanged(true);
                    property.setDefaultValue(false);
                    property.setSource("arquillian.properties");
                    ISelection selection = this.getViewer().getSelection();
                    this.getViewer().setSelection(null);
                    this.getViewer().setSelection(selection);
                    ArquillianTab.this.saveButton.setEnabled(true);
                    break;
                }
            }
            this.getViewer().update(element, null);
        }
    }

    private class PropertiesContentProvider
    implements IStructuredContentProvider {
        private PropertiesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ArquillianTab.this.properties.toArray(new ArquillianProperty[0]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            ArquillianTab.this.properties = (Set)newInput;
        }
    }

    private class PropertiesLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public PropertiesLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public Image getImage(Object element) {
            if (element == null) {
                return null;
            }
            ArquillianProperty properties = (ArquillianProperty)element;
            if (this.columnIndex == 3) {
                if (properties.isDefaultValue()) {
                    return ArquillianTab.this.getCheckOnImage();
                }
                return ArquillianTab.this.getCheckOffImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ArquillianProperty) {
                ArquillianProperty properties = (ArquillianProperty)element;
                if (this.columnIndex == 0) {
                    String name = properties.getName();
                    int index = name.lastIndexOf(".");
                    if (index > 0) {
                        name = name.substring(index + 1);
                    }
                    return name;
                }
                if (this.columnIndex == 1) {
                    return properties.getValue();
                }
                if (this.columnIndex == 2) {
                    return properties.getSource();
                }
            }
            return null;
        }
    }

    private class ServersContentProvider
    implements IStructuredContentProvider {
        private ServersContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ArquillianTab.this.servers;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            ArquillianTab.this.servers = (IServer[])newInput;
        }
    }

    private class ServersLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public ServersLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (!(element instanceof IServer)) {
                return null;
            }
            IServer server = (IServer)element;
            switch (this.columnIndex) {
                case 0: {
                    return server.getName();
                }
                case 1: {
                    IRuntime runtime = server.getRuntime();
                    if (runtime == null) break;
                    return runtime.getName();
                }
                case 2: {
                    IRuntime rt = server.getRuntime();
                    if (rt != null && rt.getLocation() != null) {
                        return rt.getLocation().toOSString();
                    }
                    return "";
                }
                case 3: {
                    String mode = server.getMode();
                    int state = server.getServerState();
                    if (state == 1) {
                        return "Starting";
                    }
                    if (state == 3) {
                        return "Stopping";
                    }
                    if (state == 4) {
                        return "Stopped";
                    }
                    if (state == 2) {
                        if (ArquillianTab.DEBUG_MODE.equals(mode)) {
                            return "Debugging";
                        }
                        return "Started";
                    }
                    return "Unknown";
                }
            }
            return null;
        }
    }
}

