/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.wizards.TypeLabelProvider;

public class ArquillianTypesSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.jboss.tools.arquillian.ui.ArquillianTypesSelectionDialog";
    private IJavaProject javaProject;
    private List<IType> allTypes;
    private List<IType> addedTypes;

    public ArquillianTypesSelectionDialog(Shell shell, IJavaProject javaProject, List<IType> addedTypes) {
        super(shell, true);
        this.javaProject = javaProject;
        this.setTitle("Classes selection");
        this.setMessage("Select classes:");
        this.setListLabelProvider(new TypeLabelProvider());
        this.addedTypes = addedTypes;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = ArquillianUIActivator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = ArquillianUIActivator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.jboss.tools.arquillian.ui", 0, "", null);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new TypesSearchItemsFilter();
    }

    protected Comparator getItemsComparator() {
        return new TypesSearchComparator();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        this.getClasses();
        for (IType type : this.allTypes) {
            contentProvider.add((Object)type, itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    public String getElementName(Object item) {
        if (item instanceof IType) {
            return ((IType)item).getFullyQualifiedName();
        }
        return null;
    }

    private void getClasses() {
        this.allTypes = new ArrayList<IType>();
        if (this.javaProject != null && this.javaProject.isOpen()) {
            IPath testSourcePath = null;
            try {
                IClasspathEntry[] rawClasspath;
                IProject project = this.javaProject.getProject();
                if (project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project, (IProgressMonitor)new NullProgressMonitor());
                    MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                    Build build = mavenProject.getBuild();
                    String testSourceDirectory = build.getTestSourceDirectory();
                    testSourcePath = Path.fromOSString((String)testSourceDirectory);
                    IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getRawLocation();
                    testSourcePath = testSourcePath.makeRelativeTo(workspacePath).makeAbsolute();
                }
                IClasspathEntry[] iClasspathEntryArray = rawClasspath = this.javaProject.getRawClasspath();
                int n = rawClasspath.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot[] roots;
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && (roots = this.javaProject.findPackageFragmentRoots(entry)) != null) {
                        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                        int n3 = roots.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                            IPath path = root.getPath();
                            String projectLocation = project.getLocation().toOSString();
                            IPath projectPath = Path.fromOSString((String)projectLocation);
                            IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getRawLocation();
                            projectPath = projectPath.makeRelativeTo(workspacePath).makeAbsolute();
                            path = (projectPath = projectPath.removeLastSegments(1)).append(path);
                            if (path == null || !path.equals((Object)testSourcePath)) {
                                IJavaElement[] children;
                                IJavaElement[] iJavaElementArray = children = root.getChildren();
                                int n5 = children.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IJavaElement child = iJavaElementArray[n6];
                                    if (child instanceof IPackageFragment) {
                                        IJavaElement[] elements;
                                        IPackageFragment packageFragment = (IPackageFragment)child;
                                        IJavaElement[] iJavaElementArray2 = elements = packageFragment.getChildren();
                                        int n7 = elements.length;
                                        int n8 = 0;
                                        while (n8 < n7) {
                                            IJavaElement element = iJavaElementArray2[n8];
                                            if (element instanceof ICompilationUnit) {
                                                IType[] types;
                                                ICompilationUnit cu = (ICompilationUnit)element;
                                                IType[] iTypeArray = types = cu.getTypes();
                                                int n9 = types.length;
                                                int n10 = 0;
                                                while (n10 < n9) {
                                                    IType type = iTypeArray[n10];
                                                    if (!this.addedTypes.contains(type)) {
                                                        this.allTypes.add(type);
                                                    }
                                                    ++n10;
                                                }
                                            }
                                            ++n8;
                                        }
                                    }
                                    ++n6;
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e1) {
                ArquillianUIActivator.log(e1);
            }
        }
    }

    private class TypesSearchComparator
    implements Comparator {
        private TypesSearchComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = this.getId(o1);
            String s2 = this.getId(o2);
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && s2 != null) {
                return -1;
            }
            return s1.compareTo(s2);
        }

        private String getId(Object element) {
            if (element instanceof IType) {
                return ((IType)element).getFullyQualifiedName();
            }
            return null;
        }
    }

    private class TypesSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private TypesSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)ArquillianTypesSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            String text = null;
            if (item instanceof IType) {
                text = ((IType)item).getFullyQualifiedName();
            }
            return this.matches(text);
        }

        protected boolean matches(String text) {
            String pattern = this.patternMatcher.getPattern();
            if (pattern.indexOf("*") != 0 & pattern.indexOf("?") != 0 & pattern.indexOf(".") != 0) {
                pattern = "*" + pattern;
                this.patternMatcher.setPattern(pattern);
            }
            return this.patternMatcher.matches(text);
        }
    }
}

