/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.editor.internal.services;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.jboss.tools.arquillian.editor.internal.model.Protocol;
import org.jboss.tools.arquillian.editor.internal.services.AbstractDependenciesService;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;

public class ProtocolDependenciesService
extends AbstractDependenciesService {
    private static final String SERVLET_PROTOCOL_GROUP_ID = "org.jboss.arquillian.protocol";
    private static final String SERVLET_PROTOCOL_ARTIFACT_ID = "arquillian-protocol-servlet";
    @Text(value="The {0} protocol requires the {1}:{2} artifact.")
    private static LocalizableText message;

    static {
        LocalizableText.init(ProtocolDependenciesService.class);
    }

    protected Status compute() {
        IProject project;
        Value value = (Value)this.context(Value.class);
        if (value != null && value.element() instanceof Protocol && (Protocol.SERVLET_25.equals(value.text()) || Protocol.SERVLET_30.equals(value.text())) && !ProtocolDependenciesService.testProtocolDependencies(project = (IProject)value.element().adapt(IProject.class))) {
            String msg = message.format(new Object[]{value.text(), SERVLET_PROTOCOL_GROUP_ID, SERVLET_PROTOCOL_ARTIFACT_ID});
            return Status.createWarningStatus((String)msg);
        }
        return Status.createOkStatus();
    }

    public static boolean testProtocolDependencies(IProject project) {
        IMavenProjectFacade facade;
        if (project != null && (facade = MavenPlugin.getMavenProjectRegistry().create(project, (IProgressMonitor)new NullProgressMonitor())) != null) {
            try {
                String version;
                MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                if (mavenProject != null && (version = ArquillianUtility.getDependencyVersion((MavenProject)mavenProject, (String)SERVLET_PROTOCOL_GROUP_ID, (String)SERVLET_PROTOCOL_ARTIFACT_ID)) != null) {
                    return true;
                }
            }
            catch (CoreException e) {
                ArquillianUIActivator.logWarning(e.getLocalizedMessage());
            }
        }
        return false;
    }

    public static List<Dependency> getDependencies(IProject project) {
        boolean isManaged;
        Dependency dependency;
        ArrayList<Dependency> dependencies;
        block4: {
            dependencies = new ArrayList<Dependency>();
            dependency = new Dependency();
            dependency.setGroupId(SERVLET_PROTOCOL_GROUP_ID);
            dependency.setArtifactId(SERVLET_PROTOCOL_ARTIFACT_ID);
            isManaged = false;
            try {
                MavenProject mavenProject;
                IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project, (IProgressMonitor)new NullProgressMonitor());
                if (facade == null || (mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor())) == null) break block4;
                DependencyManagement depMgmt = mavenProject.getDependencyManagement();
                List mgmtDeps = depMgmt.getDependencies();
                for (Dependency mgmtDep : mgmtDeps) {
                    if (!SERVLET_PROTOCOL_GROUP_ID.equals(mgmtDep.getGroupId()) || !SERVLET_PROTOCOL_ARTIFACT_ID.equals(mgmtDep.getArtifactId())) continue;
                    isManaged = true;
                    break;
                }
            }
            catch (CoreException e) {
                ArquillianUIActivator.logWarning(e.getLocalizedMessage());
            }
        }
        if (!isManaged) {
            String coords = String.valueOf(dependency.getGroupId()) + ":" + dependency.getArtifactId() + ":[0,)";
            String version = ArquillianUtility.getHighestVersion((String)coords);
            dependency.setVersion(version);
        }
        dependency.setScope("test");
        dependencies.add(dependency);
        return dependencies;
    }
}

