/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.classpath;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.arquillian.core.ArquillianCoreActivator;

public class ArquillianClassLoader
extends URLClassLoader {
    public ArquillianClassLoader(IJavaProject project) {
        super(ArquillianClassLoader.getURLs(project), ClassLoader.getSystemClassLoader());
    }

    private static URL[] getURLs(IJavaProject project) {
        Set<URL> urls = ArquillianClassLoader.getURLSet(project);
        return urls.toArray(new URL[0]);
    }

    private static File getRawLocationFile(IPath simplePath) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(simplePath);
        File file = null;
        file = resource != null ? ResourcesPlugin.getWorkspace().getRoot().findMember(simplePath).getLocation().toFile() : simplePath.toFile();
        return file;
    }

    private static Set<URL> getURLSet(IJavaProject jProject) {
        HashSet<URL> urls = new HashSet<URL>();
        HashSet<IJavaProject> dependentProjects = new HashSet<IJavaProject>();
        if (jProject == null) {
            return urls;
        }
        try {
            IClasspathEntry[] entries = jProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry resLib;
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 3) {
                    ArquillianClassLoader.addSource(jProject, urls, entry);
                } else if (entry.getEntryKind() == 1) {
                    resLib = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                    ArquillianClassLoader.addLibrary(urls, resLib);
                } else if (entry.getEntryKind() == 2) {
                    ArquillianClassLoader.addProject(urls, entry, dependentProjects);
                } else if (entry.getEntryKind() == 4) {
                    resLib = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                    ArquillianClassLoader.addLibrary(urls, resLib);
                } else if (entry.getEntryKind() == 5 && !entry.getPath().segment(0).toString().endsWith("JRE_CONTAINER")) {
                    ArquillianClassLoader.addContainer(jProject, urls, entry, dependentProjects);
                }
                ++i;
            }
        }
        catch (Exception e) {
            ArquillianCoreActivator.log(e);
        }
        return urls;
    }

    private static void addContainer(IJavaProject jProject, Set<URL> urls, IClasspathEntry entry, Set<IJavaProject> dependentProjects) throws JavaModelException, MalformedURLException {
        IClasspathEntry[] resLibs = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)jProject).getClasspathEntries();
        int i = 0;
        while (i < resLibs.length) {
            if (resLibs[i] != null) {
                if (resLibs[i].getEntryKind() == 2) {
                    ArquillianClassLoader.addProject(urls, resLibs[i], dependentProjects);
                } else if (resLibs[i].getEntryKind() == 5) {
                    ArquillianClassLoader.addContainer(jProject, urls, resLibs[i], dependentProjects);
                } else if (resLibs[i].getEntryKind() == 1) {
                    ArquillianClassLoader.addLibrary(urls, resLibs[i]);
                } else if (resLibs[i].getEntryKind() == 3) {
                    ArquillianClassLoader.addSource(jProject, urls, resLibs[i]);
                }
            }
            ++i;
        }
    }

    private static void addSource(IJavaProject jProject, Set<URL> urls, IClasspathEntry entry) throws JavaModelException, MalformedURLException {
        IPath path = entry.getOutputLocation();
        if (path == null) {
            path = jProject.getOutputLocation();
        }
        ArquillianClassLoader.addPath(urls, path);
        IPath sourcePath = entry.getPath();
        if (sourcePath != null) {
            ArquillianClassLoader.addPath(urls, sourcePath);
        }
    }

    private static void addPath(Set<URL> urls, IPath path) throws MalformedURLException {
        File file = ArquillianClassLoader.getRawLocationFile(path);
        if (file.exists()) {
            urls.add(file.toURI().toURL());
        }
    }

    private static void addProject(Set<URL> urls, IClasspathEntry entry, Set<IJavaProject> dependentProjects) {
        IJavaProject javaProject;
        IClasspathEntry projectEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        IPath path = projectEntry.getPath();
        String name = path.segment(0);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists() && (javaProject = JavaCore.create((IProject)project)).exists() && !dependentProjects.contains(javaProject)) {
            dependentProjects.add(javaProject);
            urls.addAll(ArquillianClassLoader.getURLSet(javaProject));
        }
    }

    private static void addLibrary(Set<URL> urls, IClasspathEntry resLib) throws MalformedURLException {
        IPath path = resLib.getPath();
        String ls = path.lastSegment();
        if (ls != null && ls.length() > 0) {
            ArquillianClassLoader.addPath(urls, path);
        }
    }
}

