/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.archives;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.arquillian.core.internal.archives.Archive;
import org.jboss.tools.arquillian.core.internal.archives.ArchiveLocation;

public class ArchiveContainer {
    private static Map<ArchiveLocation, Archive> archives = new HashMap<ArchiveLocation, Archive>();

    public static Archive getArchive(ArchiveLocation location) {
        return archives.get(location);
    }

    public static void putArchive(ArchiveLocation location, Archive archive) {
        archives.put(location, archive);
    }

    public static void remove(IResource resource) {
        block5: {
            block4: {
                if (!(resource instanceof IProject)) break block4;
                IProject project = (IProject)resource;
                String projectName = project.getName();
                Set<ArchiveLocation> keySet = archives.keySet();
                Iterator<ArchiveLocation> iter = keySet.iterator();
                while (iter.hasNext()) {
                    ArchiveLocation location = iter.next();
                    if (!projectName.equals(location.getProjectName())) continue;
                    iter.remove();
                }
                break block5;
            }
            if (!(resource instanceof IFile)) break block5;
            IFile file = (IFile)resource;
            IJavaElement element = JavaCore.create((IFile)file);
            if (!(element instanceof ICompilationUnit)) {
                return;
            }
            ICompilationUnit unit = (ICompilationUnit)element;
            IType type = unit.findPrimaryType();
            if (type != null) {
                String fqn = type.getFullyQualifiedName();
                String projectName = resource.getProject().getName();
                Set<ArchiveLocation> keySet = archives.keySet();
                Iterator<ArchiveLocation> iter = keySet.iterator();
                while (iter.hasNext()) {
                    ArchiveLocation location = iter.next();
                    if (!projectName.equals(location.getProjectName()) || !fqn.equals(location.getFullyQualifiedName())) continue;
                    iter.remove();
                }
            }
        }
    }
}

